/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.dcp;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CertificateAuthenticator;
import com.couchbase.client.core.env.PasswordAuthenticator;
import com.couchbase.client.core.env.PropertyLoader;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.topology.ClusterTopologyWithBucket;
import com.couchbase.client.core.topology.CouchbaseBucketTopology;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.core.util.HostAndPort;
import com.couchbase.client.dcp.core.utils.CbCollections;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.ClusterOptions;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.connector.config.ConfigException;
import com.couchbase.connector.config.ScopeAndCollection;
import com.couchbase.connector.config.common.ClientCertConfig;
import com.couchbase.connector.config.common.CouchbaseConfig;
import com.couchbase.connector.config.es.ConnectorConfig;
import com.couchbase.connector.dcp.MarkableCrc32;
import com.couchbase.connector.dcp.ResolvedBucketConfig;
import com.couchbase.connector.util.SeedNodeHelper;
import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class CouchbaseHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CouchbaseHelper.class);
    private static final Duration CONFIG_TIMEOUT = Duration.ofSeconds(30L);

    private CouchbaseHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static Consumer<ClusterEnvironment.Builder> environmentConfigurator(ConnectorConfig connectorConfig) {
        return env -> CouchbaseHelper.configure(env, connectorConfig);
    }

    private static void configure(ClusterEnvironment.Builder env, ConnectorConfig connectorConfig) {
        CouchbaseConfig config = connectorConfig.couchbase();
        ((ClusterEnvironment.Builder)((ClusterEnvironment.Builder)env.ioConfig(io -> io.networkResolution(config.network()))).timeoutConfig(timeout -> timeout.connectTimeout(Duration.ofSeconds(10L)))).securityConfig(security -> {
            if (config.secureConnection()) {
                security.enableTls(true).enableHostnameVerification(config.hostnameVerification());
                if (!config.caCert().isEmpty()) {
                    security.trustCertificates(config.caCert());
                } else {
                    connectorConfig.trustStore().ifPresent(it -> security.trustStore(it.get()));
                }
            }
        });
        CouchbaseHelper.applyCustomEnvironmentProperties(env, config);
    }

    private static void applyCustomEnvironmentProperties(ClusterEnvironment.Builder envBuilder, CouchbaseConfig config) {
        try {
            envBuilder.load(PropertyLoader.fromMap(config.env()));
        }
        catch (Exception e) {
            throw new ConfigException("Failed to apply Couchbase environment properties; " + e.getMessage());
        }
    }

    static List<String> qualifyPorts(List<String> hosts, ConnectionString.PortType defaultPortType) {
        return ConnectionString.create((String)String.join((CharSequence)",", hosts)).hosts().stream().map(s -> {
            HostAndPort hap = new HostAndPort(s.host(), s.port());
            if (s.port() == 0) {
                return hap.format();
            }
            ConnectionString.PortType portType = s.portType().orElse(defaultPortType);
            return hap.format() + "=" + CouchbaseHelper.getAlias(portType);
        }).collect(Collectors.toList());
    }

    static String getAlias(ConnectionString.PortType portType) {
        return portType.name().toLowerCase(Locale.ROOT);
    }

    public static Cluster createCluster(ConnectorConfig config) {
        return CouchbaseHelper.createCluster(config.couchbase(), CouchbaseHelper.environmentConfigurator(config));
    }

    public static Cluster createCluster(CouchbaseConfig config, Consumer<ClusterEnvironment.Builder> env) {
        List<String> hosts = config.hosts();
        hosts = CouchbaseHelper.qualifyPorts(hosts, ConnectionString.PortType.MANAGER);
        String connectionString = String.join((CharSequence)",", hosts);
        Authenticator authenticator = CouchbaseHelper.authenticator(config);
        return Cluster.connect((String)connectionString, (ClusterOptions)ClusterOptions.clusterOptions((Authenticator)authenticator).environment(env));
    }

    private static Authenticator authenticator(CouchbaseConfig config) {
        ClientCertConfig clientCert = config.clientCert();
        return clientCert.use() ? CertificateAuthenticator.fromKeyStore((KeyStore)clientCert.getKeyStore(), (String)clientCert.password()) : PasswordAuthenticator.create((String)config.username(), (String)config.password());
    }

    @Deprecated
    public static Bucket openMetadataBucket(ConnectorConfig config) {
        Cluster cluster = CouchbaseHelper.createCluster(config.couchbase(), CouchbaseHelper.environmentConfigurator(config));
        return cluster.bucket(config.couchbase().metadataBucket());
    }

    public static int getNumPartitions(Bucket bucket) {
        return CouchbaseHelper.doGetBucketConfig(bucket).numberOfPartitions();
    }

    public static int getNumPartitions(Collection collection) {
        return CouchbaseHelper.doGetBucketConfig(collection).numberOfPartitions();
    }

    private static CouchbaseBucketConfig doGetBucketConfig(Bucket bucket) {
        return (CouchbaseBucketConfig)CouchbaseHelper.getConfig(bucket).block(CONFIG_TIMEOUT);
    }

    private static CouchbaseBucketConfig doGetBucketConfig(Collection collection) {
        return (CouchbaseBucketConfig)CouchbaseHelper.getConfig(collection).block(CONFIG_TIMEOUT);
    }

    public static Mono<BucketConfig> getConfig(Bucket bucket) {
        return CouchbaseHelper.getConfig(bucket.core(), bucket.name());
    }

    public static BucketConfig getConfig(Bucket bucket, Duration timeout) {
        return (BucketConfig)CouchbaseHelper.getConfig(bucket).block(timeout);
    }

    public static Mono<BucketConfig> getConfig(Collection collection) {
        return CouchbaseHelper.getConfig(collection.core(), collection.bucketName());
    }

    public static Mono<BucketConfig> getConfig(Core core, String bucketName) {
        return core.configurationProvider().configs().flatMap(clusterConfig -> Mono.justOrEmpty((Object)clusterConfig.bucketConfig(bucketName))).filter(CouchbaseHelper::hasPartitionInfo).next();
    }

    public static Mono<ClusterTopologyWithBucket> getTopology(Core core, String bucketName) {
        return core.configurationProvider().configs().flatMap(clusterConfig -> Mono.justOrEmpty((Object)clusterConfig.bucketTopology(bucketName))).filter(CouchbaseHelper::hasPartitionInfo).next();
    }

    private static boolean hasPartitionInfo(ClusterTopologyWithBucket topology) {
        CouchbaseBucketTopology bucketTopology = (CouchbaseBucketTopology)topology.bucket();
        return bucketTopology.numberOfPartitions() > 0;
    }

    public static Mono<ClusterTopologyWithBucket> getTopology(Bucket bucket) {
        return CouchbaseHelper.getTopology(bucket.core(), bucket.name());
    }

    public static ClusterTopologyWithBucket getTopology(Bucket bucket, Duration timeout) {
        return (ClusterTopologyWithBucket)CouchbaseHelper.getTopology(bucket).block(timeout);
    }

    private static boolean hasPartitionInfo(BucketConfig config) {
        return ((CouchbaseBucketConfig)config).numberOfPartitions() > 0;
    }

    public static ResolvedBucketConfig getBucketConfig(CouchbaseConfig config, Bucket bucket) {
        CouchbaseBucketConfig bucketConfig = CouchbaseHelper.doGetBucketConfig(bucket);
        return new ResolvedBucketConfig(bucketConfig, config.secureConnection());
    }

    public static Set<SeedNode> getKvNodes(CouchbaseConfig config, Bucket bucket) {
        ConnectionString connectionString = ConnectionString.create((String)String.join((CharSequence)",", config.hosts()));
        Duration timeout = Duration.ofSeconds(30L);
        return SeedNodeHelper.getKvNodes(bucket, connectionString, config.secureConnection(), config.network(), timeout);
    }

    public static Bucket waitForBucket(Cluster cluster, String bucketName) {
        Bucket bucket = cluster.bucket(bucketName);
        Duration timeout = bucket.environment().timeoutConfig().connectTimeout();
        timeout = timeout.multipliedBy(2L);
        bucket.waitUntilReady(timeout, WaitUntilReadyOptions.waitUntilReadyOptions().serviceTypes(CbCollections.setOf((Object[])new ServiceType[]{ServiceType.KV})));
        return bucket;
    }

    public static Collection getMetadataCollection(Bucket metadataBucket, CouchbaseConfig config) {
        ScopeAndCollection c = config.metadataCollection();
        return metadataBucket.scope(c.getScope()).collection(c.getCollection());
    }

    public static Collection getMetadataCollection(Cluster cluster, CouchbaseConfig config) {
        Bucket bucket = CouchbaseHelper.waitForBucket(cluster, config.metadataBucket());
        return CouchbaseHelper.getMetadataCollection(bucket, config);
    }

    public static Optional<String> forceKeyToPartition(String key, int desiredPartition, int numPartitions) {
        Preconditions.checkArgument((desiredPartition < numPartitions ? 1 : 0) != 0);
        Preconditions.checkArgument((numPartitions > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((desiredPartition >= 0 ? 1 : 0) != 0);
        int MAX_ITERATIONS = 10000000;
        MarkableCrc32 crc32 = new MarkableCrc32();
        byte[] keyBytes = (key + "#").getBytes(StandardCharsets.UTF_8);
        crc32.update(keyBytes, 0, keyBytes.length);
        crc32.mark();
        for (long salt = 0L; salt < 10000000L; ++salt) {
            crc32.reset();
            String saltString = Long.toHexString(salt);
            int max = saltString.length();
            for (int i = 0; i < max; ++i) {
                crc32.update(saltString.charAt(i));
            }
            long rv = crc32.getValue() >> 16 & 0x7FFFL;
            int actualPartition = (int)rv & numPartitions - 1;
            if (actualPartition != desiredPartition) continue;
            return Optional.of(new String(keyBytes, StandardCharsets.UTF_8) + saltString);
        }
        LOGGER.warn("Failed to force partition for {} after {} iterations.", (Object)key, (Object)10000000);
        return Optional.empty();
    }
}

