/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.dcp;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.util.IllegalReferenceCountException;
import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.env.SecurityConfig;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.util.HostAndPort;
import com.couchbase.client.dcp.Authenticator;
import com.couchbase.client.dcp.CertificateAuthenticator;
import com.couchbase.client.dcp.Client;
import com.couchbase.client.dcp.CredentialsProvider;
import com.couchbase.client.dcp.PasswordAuthenticator;
import com.couchbase.client.dcp.SecurityConfig;
import com.couchbase.client.dcp.StaticCredentialsProvider;
import com.couchbase.client.dcp.StreamFrom;
import com.couchbase.client.dcp.StreamTo;
import com.couchbase.client.dcp.config.DcpControl;
import com.couchbase.client.dcp.core.logging.RedactionLevel;
import com.couchbase.client.dcp.highlevel.DatabaseChangeListener;
import com.couchbase.client.dcp.highlevel.Deletion;
import com.couchbase.client.dcp.highlevel.DocumentChange;
import com.couchbase.client.dcp.highlevel.Mutation;
import com.couchbase.client.dcp.highlevel.SnapshotMarker;
import com.couchbase.client.dcp.highlevel.StreamFailure;
import com.couchbase.client.dcp.message.PartitionAndSeqno;
import com.couchbase.client.dcp.message.StreamFlag;
import com.couchbase.client.dcp.state.FailoverLogEntry;
import com.couchbase.client.dcp.state.PartitionState;
import com.couchbase.client.dcp.state.SessionState;
import com.couchbase.client.dcp.transport.netty.ChannelFlowController;
import com.couchbase.connector.VersionHelper;
import com.couchbase.connector.cluster.PanicButton;
import com.couchbase.connector.cluster.consul.ReactorHelper;
import com.couchbase.connector.config.ScopeAndCollection;
import com.couchbase.connector.config.common.ClientCertConfig;
import com.couchbase.connector.config.common.CouchbaseConfig;
import com.couchbase.connector.config.common.TrustStoreConfig;
import com.couchbase.connector.dcp.Checkpoint;
import com.couchbase.connector.dcp.CheckpointService;
import com.couchbase.connector.dcp.Event;
import com.couchbase.connector.elasticsearch.Metrics;
import com.google.common.collect.ImmutableList;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.security.KeyStore;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcpHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DcpHelper.class);

    private DcpHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static String metadataDocumentIdPrefix() {
        return "_connector:cbes:";
    }

    public static boolean isMetadata(Event e) {
        return e.getKey().startsWith(DcpHelper.metadataDocumentIdPrefix());
    }

    public static void ackAndRelease(ChannelFlowController flowController, ByteBuf buffer) throws IllegalReferenceCountException {
        try {
            flowController.ack(buffer);
        }
        catch (IllegalReferenceCountException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.warn("Flow control ack failed (channel already closed?)", (Throwable)e);
        }
        buffer.release();
    }

    public static Client newClient(String groupName, CouchbaseConfig config, Set<SeedNode> kvNodes, @Nullable TrustStoreConfig trustStoreConfig) {
        Set seedNodes = kvNodes.stream().map(node -> new HostAndPort(node.address(), ((Integer)node.kvPort().orElseThrow(() -> new AssertionError((Object)"seed node missing KV port"))).intValue())).map(HostAndPort::format).collect(Collectors.toSet());
        Set collectionNames = config.collections().stream().map(ScopeAndCollection::format).collect(Collectors.toSet());
        Client.Builder builder = Client.builder().meterRegistry((MeterRegistry)Metrics.registry()).userAgent("elasticsearch-connector", VersionHelper.getVersion(), new String[]{groupName}).bootstrapTimeout(config.dcp().connectTimeout()).socketConnectTimeout(config.dcp().connectTimeout().toMillis()).seedNodes(seedNodes).networkResolution(NetworkResolution.valueOf((String)config.network().name())).bucket(config.bucket()).authenticator(DcpHelper.authenticator(config)).controlParam(DcpControl.Names.SET_NOOP_INTERVAL, (Object)20).optionalStreamFlags(Set.of(StreamFlag.IGNORE_PURGED_TOMBSTONES)).compression(config.dcp().compression()).collectionsAware(true).scopeName(config.scope()).collectionNames(collectionNames).mitigateRollbacks(config.dcp().persistencePollingInterval().toMillis(), TimeUnit.MILLISECONDS).flowControl(DcpHelper.toSaturatedInt(config.dcp().flowControlBuffer().getBytes())).bufferAckWatermark(60);
        if (config.secureConnection()) {
            SecurityConfig.Builder securityBuilder = com.couchbase.client.dcp.SecurityConfig.builder().enableTls(true).enableHostnameVerification(config.hostnameVerification());
            if (!config.caCert().isEmpty()) {
                securityBuilder.trustCertificates(config.caCert());
            } else if (trustStoreConfig != null) {
                securityBuilder.trustStore(trustStoreConfig.get());
            } else {
                securityBuilder.trustCertificates(SecurityConfig.defaultCaCertificates());
            }
            builder.securityConfig(securityBuilder);
        }
        return builder.build();
    }

    private static Authenticator authenticator(CouchbaseConfig config) {
        ClientCertConfig clientCert = config.clientCert();
        return clientCert.use() ? CertificateAuthenticator.fromKeyStore((KeyStore)clientCert.getKeyStore(), (String)clientCert.password()) : new PasswordAuthenticator((CredentialsProvider)new StaticCredentialsProvider(config.username(), config.password()));
    }

    private static int toSaturatedInt(long value) {
        return (int)Math.min(Integer.MAX_VALUE, Math.max(Integer.MIN_VALUE, value));
    }

    public static ImmutableList<Long> getCurrentSeqnos(Client dcpClient, Set<Integer> partitions) {
        int numPartitions = dcpClient.numPartitions();
        dcpClient.initializeState(StreamFrom.NOW, StreamTo.INFINITY).block();
        Object[] backfillTargetSeqno = new Long[numPartitions];
        for (int i = 0; i < numPartitions; ++i) {
            backfillTargetSeqno[i] = partitions.contains(i) ? dcpClient.sessionState().get(i).getStartSeqno() : 0L;
        }
        return ImmutableList.copyOf((Object[])backfillTargetSeqno);
    }

    public static Map<Integer, Long> getCurrentSeqnosAsMap(Client dcpClient, Set<Integer> partitions, Duration timeout) {
        Map partitionToSeqno = (Map)ReactorHelper.blockSingle(dcpClient.getSeqnos().collectMap(PartitionAndSeqno::partition, PartitionAndSeqno::seqno, TreeMap::new), timeout);
        if (!partitions.isEmpty()) {
            partitionToSeqno.keySet().retainAll(partitions);
        }
        return partitionToSeqno;
    }

    public static void initEventListener(Client dcpClient, final PanicButton panicButton, final Consumer<Event> eventSink) {
        dcpClient.nonBlockingListener(new DatabaseChangeListener(){

            public void onFailure(StreamFailure streamFailure) {
                panicButton.panic("DCP stream failure.", streamFailure.getCause());
            }

            public void onMutation(Mutation mutation) {
                this.onMutationOrDeletion((DocumentChange)mutation);
            }

            public void onDeletion(Deletion deletion) {
                this.onMutationOrDeletion((DocumentChange)deletion);
            }

            private void onMutationOrDeletion(DocumentChange change) {
                eventSink.accept(new Event(change));
            }
        });
    }

    public static void initSessionState(Client dcpClient, CheckpointService checkpointService, Set<Integer> partitions) throws IOException {
        Map<Integer, Checkpoint> positions = checkpointService.load(partitions);
        SessionState sessionState = dcpClient.sessionState();
        LOGGER.debug("Initializing DCP session state from checkpoint: {}", positions);
        for (Map.Entry<Integer, Checkpoint> entry : positions.entrySet()) {
            int partition = entry.getKey();
            Checkpoint checkpoint = entry.getValue();
            if (checkpoint == null) continue;
            PartitionState ps = sessionState.get(partition);
            ps.setStartSeqno(checkpoint.getSeqno(), new SnapshotMarker(checkpoint.getSnapshot().getStartSeqno(), checkpoint.getSnapshot().getEndSeqno()));
            ps.setFailoverLog(Collections.singletonList(new FailoverLogEntry(-1L, checkpoint.getVbuuid())));
            LOGGER.debug("Initialized partition {} state = {}", (Object)partition, (Object)ps);
        }
    }

    public static List<Integer> allPartitions(Client dcpClient) {
        return DcpHelper.allPartitions(dcpClient.numPartitions());
    }

    public static List<Integer> allPartitions(int numPartitions) {
        ArrayList<Integer> allPartitions = new ArrayList<Integer>(numPartitions);
        for (int i = 0; i < numPartitions; ++i) {
            allPartitions.add(i);
        }
        return allPartitions;
    }

    public static void setRedactionLevel(com.couchbase.client.core.logging.RedactionLevel redactionLevel) {
        switch (redactionLevel) {
            case NONE: {
                RedactionLevel.set((RedactionLevel)RedactionLevel.NONE);
                break;
            }
            case PARTIAL: {
                RedactionLevel.set((RedactionLevel)RedactionLevel.PARTIAL);
                break;
            }
            case FULL: {
                RedactionLevel.set((RedactionLevel)RedactionLevel.FULL);
                break;
            }
            default: {
                throw new IllegalArgumentException("Don't know how to map redaction level '" + String.valueOf(redactionLevel) + "' to DCP redaction level.");
            }
        }
    }
}

