/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.dcp;

import com.couchbase.client.dcp.highlevel.DocumentChange;
import com.couchbase.client.dcp.highlevel.Mutation;
import com.couchbase.client.dcp.highlevel.StreamOffset;
import com.couchbase.connector.dcp.Checkpoint;
import com.couchbase.connector.dcp.SnapshotMarker;
import java.util.Objects;

public class Event {
    private final DocumentChange change;
    private final boolean mutation;
    private final long receivedNanos = System.nanoTime();

    public Event(DocumentChange change) {
        this.change = Objects.requireNonNull(change);
        this.mutation = change instanceof Mutation;
    }

    public void release() {
        this.change.flowControlAck();
    }

    public int getVbucket() {
        return this.change.getVbucket();
    }

    public String getKey() {
        return this.change.getKey();
    }

    public String getKey(boolean qualifiedWithScopeAndCollection) {
        return qualifiedWithScopeAndCollection ? this.change.getQualifiedKey() : this.change.getKey();
    }

    public boolean isMutation() {
        return this.mutation;
    }

    public long getReceivedNanos() {
        return this.receivedNanos;
    }

    public long getTracingToken() {
        return this.change.getTracingToken();
    }

    public long getSeqno() {
        return this.change.getOffset().getSeqno();
    }

    public Checkpoint getCheckpoint() {
        return Event.toCheckpoint(this.change.getOffset());
    }

    private static Checkpoint toCheckpoint(StreamOffset offset) {
        return new Checkpoint(offset.getVbuuid(), offset.getSeqno(), new SnapshotMarker(offset.getSnapshot().getStartSeqno(), offset.getSnapshot().getEndSeqno()));
    }

    public DocumentChange getChange() {
        return this.change;
    }

    public byte[] getContent() {
        return this.change.getContent();
    }

    public String toString() {
        return this.change.toString();
    }
}

