/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.dcp;

import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.HostAndPort;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ResolvedBucketConfig {
    private final boolean sslEnabled;
    private final CouchbaseBucketConfig config;
    private final List<NodeInfo> allNodes;

    public ResolvedBucketConfig(CouchbaseBucketConfig config, boolean sslEnabled) {
        this.config = Objects.requireNonNull(config);
        this.sslEnabled = sslEnabled;
        this.allNodes = config.nodes();
    }

    public long rev() {
        return this.config.rev();
    }

    public String uuid() {
        return this.config.uuid();
    }

    public int numberOfPartitions() {
        return this.config.numberOfPartitions();
    }

    public int numberOfReplicas() {
        return this.config.numberOfReplicas();
    }

    public List<NodeInfo> nodes() {
        return this.allNodes;
    }

    public List<HostAndPort> getKvAddresses() {
        return this.allNodes.stream().filter(this::hasKvService).map(this::getKvAddress).collect(Collectors.toList());
    }

    private HostAndPort getKvAddress(NodeInfo node) {
        int port = this.getServicePortMap(node).get(ServiceType.KV);
        return new HostAndPort(node.hostname(), port);
    }

    private Map<ServiceType, Integer> getServicePortMap(NodeInfo node) {
        return this.sslEnabled ? node.sslServices() : node.services();
    }

    private boolean hasKvService(NodeInfo node) {
        return this.getServicePortMap(node).containsKey(ServiceType.KV);
    }
}

