/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch;

import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.dcp.metrics.LogLevel;
import com.couchbase.connector.config.es.TypeConfig;
import com.couchbase.connector.dcp.DcpHelper;
import com.couchbase.connector.dcp.Event;
import com.couchbase.connector.elasticsearch.sink.Operation;
import com.couchbase.connector.elasticsearch.sink.RejectOperation;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentLifecycle {
    private static final Logger log = LoggerFactory.getLogger(DocumentLifecycle.class);
    private static volatile LogLevel logLevel = LogLevel.DEBUG;

    public static void setLogLevel(LogLevel level) {
        logLevel = level;
        log.info("Document lifecycle milestones will be logged to this category at {} level.", (Object)level);
    }

    private DocumentLifecycle() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static void logReceivedFromCouchbase(Event event, int worker) {
        if (DocumentLifecycle.shouldLog(event)) {
            LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
            details.put("revision", event.getChange().getRevision());
            details.put("type", event.isMutation() ? "mutation" : "deletion");
            details.put("partition", event.getVbucket());
            details.put("sequenceNumber", event.getSeqno());
            details.put("assignedToWorker", worker);
            details.put("usSinceCouchbaseChange(might be inaccurate before Couchbase 7)", event.getChange().getTimestamp().until(Instant.now(), ChronoUnit.MICROS));
            DocumentLifecycle.logMilestone(event, Milestone.RECEIVED_FROM_COUCHBASE, details);
        }
    }

    public static void logMatchedTypeRule(Event event, String index, TypeConfig typeConfig) {
        if (DocumentLifecycle.shouldLog(event)) {
            LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
            details.put("elasticsearchIndex", index);
            details.put("typeConfig", typeConfig.toString());
            DocumentLifecycle.logMilestone(event, Milestone.MATCHED_TYPE_RULE, details);
        }
    }

    public static void logSkippedBecauseMatchedNoRules(Event event) {
        if (DocumentLifecycle.shouldLog(event)) {
            DocumentLifecycle.logMilestone(event, Milestone.SKIPPED_BECAUSE_MATCHED_NO_RULES);
        }
    }

    public static void logSkippedBecauseMatchedIgnoredType(Event event, TypeConfig typeConfig) {
        if (DocumentLifecycle.shouldLog(event)) {
            LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
            details.put("typeConfig", typeConfig);
            DocumentLifecycle.logMilestone(event, Milestone.SKIPPED_BECAUSE_RULE_SAYS_IGNORE, details);
        }
    }

    public static void logSkippedBecauseRuleSaysIgnoreDeletes(Event event) {
        DocumentLifecycle.logMilestone(event, Milestone.SKIPPED_BECAUSE_RULE_SAYS_IGNORE_DELETES);
    }

    public static void logSkippedBecauseNewerVersionReceived(Event event, long newerVersionTracingToken) {
        if (logLevel.isEnabled(log)) {
            LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
            details.put("newerVersionTracingToken", newerVersionTracingToken);
            DocumentLifecycle.logMilestone(event, Milestone.SKIPPED_BECAUSE_NEWER_VERSION_RECEIVED, details);
        }
    }

    public static void logEsWriteStarted(List<Operation> requests, int attemptCounter) {
        if (logLevel.isEnabled(log)) {
            LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
            details.put("attempt", attemptCounter);
            for (Operation request : requests) {
                if (!DocumentLifecycle.shouldLog(request)) continue;
                DocumentLifecycle.logMilestone(request.getEvent(), Milestone.ELASTICSEARCH_WRITE_STARTED, details);
            }
        }
    }

    public static void logEsWriteSucceeded(Operation request) {
        if (DocumentLifecycle.shouldLog(request)) {
            DocumentLifecycle.logMilestone(request.getEvent(), Milestone.ELASTICSEARCH_WRITE_SUCCEEDED);
        }
    }

    public static void logEsWriteFailedWillRetry(Operation request) {
        if (DocumentLifecycle.shouldLog(request)) {
            DocumentLifecycle.logMilestone(request.getEvent(), Milestone.ELASTICSEARCH_WRITE_FAILED_WILL_RETRY);
        }
    }

    public static void logEsWriteRejected(Operation request, int httpStatusCode, String message) {
        if (DocumentLifecycle.shouldLog(request)) {
            LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
            details.put("httpStatusCode", httpStatusCode);
            details.put("rejectionMessage", message);
            DocumentLifecycle.logMilestone(request.getEvent(), Milestone.ELASTICSEARCH_WRITE_PERMANENTLY_REJECTED, details);
        }
    }

    private static void logMilestone(Event event, Milestone milestone) {
        DocumentLifecycle.logMilestone(event, milestone, Collections.emptyMap());
    }

    private static void logMilestone(Event event, Milestone milestone, Map<String, Object> milestoneDetails) {
        if (DocumentLifecycle.shouldLog(event)) {
            LinkedHashMap<String, Object> message = new LinkedHashMap<String, Object>();
            message.put("milestone", (Object)milestone);
            message.put("tracingToken", event.getTracingToken());
            message.put("documentId", event.getKey(true));
            message.putAll(milestoneDetails);
            message.put("usSinceReceipt", TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - event.getReceivedNanos()));
            logLevel.log(log, Mapper.encodeAsString(message));
        }
    }

    private static boolean shouldLog(Event event) {
        return logLevel.isEnabled(log) && !DcpHelper.isMetadata(event);
    }

    private static boolean shouldLog(Operation request) {
        return DocumentLifecycle.shouldLog(request.getEvent()) && !(request instanceof RejectOperation);
    }

    public static enum Milestone {
        RECEIVED_FROM_COUCHBASE,
        MATCHED_TYPE_RULE,
        SKIPPED_BECAUSE_MATCHED_NO_RULES,
        SKIPPED_BECAUSE_RULE_SAYS_IGNORE,
        SKIPPED_BECAUSE_RULE_SAYS_IGNORE_DELETES,
        SKIPPED_BECAUSE_NEWER_VERSION_RECEIVED,
        ELASTICSEARCH_WRITE_STARTED,
        ELASTICSEARCH_WRITE_SUCCEEDED,
        ELASTICSEARCH_WRITE_FAILED_WILL_RETRY,
        ELASTICSEARCH_WRITE_PERMANENTLY_REJECTED;

    }
}

