/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.logging.LogRedaction;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.logging.RedactionLevel;
import com.couchbase.client.core.topology.ClusterIdentifier;
import com.couchbase.client.core.topology.ClusterTopologyWithBucket;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.dcp.Client;
import com.couchbase.client.dcp.StreamFrom;
import com.couchbase.client.dcp.StreamTo;
import com.couchbase.client.dcp.metrics.LogLevel;
import com.couchbase.client.dcp.util.PartitionSet;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.Collection;
import com.couchbase.connector.VersionHelper;
import com.couchbase.connector.cluster.DefaultPanicButton;
import com.couchbase.connector.cluster.Membership;
import com.couchbase.connector.cluster.PanicButton;
import com.couchbase.connector.cluster.k8s.ReplicaChangeWatcher;
import com.couchbase.connector.cluster.k8s.StatefulSetInfo;
import com.couchbase.connector.config.common.CouchbaseConfig;
import com.couchbase.connector.config.common.ImmutableGroupConfig;
import com.couchbase.connector.config.es.ConnectorConfig;
import com.couchbase.connector.config.es.ImmutableConnectorConfig;
import com.couchbase.connector.config.es.TypeConfig;
import com.couchbase.connector.dcp.Checkpoint;
import com.couchbase.connector.dcp.CheckpointDao;
import com.couchbase.connector.dcp.CheckpointService;
import com.couchbase.connector.dcp.CouchbaseCheckpointDao;
import com.couchbase.connector.dcp.CouchbaseHelper;
import com.couchbase.connector.dcp.DcpHelper;
import com.couchbase.connector.elasticsearch.DocumentLifecycle;
import com.couchbase.connector.elasticsearch.ErrorListener;
import com.couchbase.connector.elasticsearch.Metrics;
import com.couchbase.connector.elasticsearch.cli.AbstractCliCommand;
import com.couchbase.connector.elasticsearch.cli.CheckpointClear;
import com.couchbase.connector.elasticsearch.io.RequestFactory;
import com.couchbase.connector.elasticsearch.sink.SinkOps;
import com.couchbase.connector.elasticsearch.sink.SinkWorkerGroup;
import com.couchbase.connector.util.HttpServer;
import com.couchbase.connector.util.KeyStoreHelper;
import com.couchbase.connector.util.RuntimeHelper;
import com.couchbase.connector.util.ThrowableHelper;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.micrometer.core.instrument.Tag;
import java.io.File;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import joptsimple.OptionSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchConnector
extends AbstractCliCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchConnector.class);

    private static Slf4jReporter newSlf4jReporter(Duration logInterval) {
        Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)Metrics.dropwizardRegistry()).convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS).outputTo(LoggerFactory.getLogger((String)"cbes.metrics")).withLoggingLevel(Slf4jReporter.LoggingLevel.INFO).build();
        if (logInterval.toMillis() > 0L) {
            reporter.start(logInterval.toMillis(), logInterval.toMillis(), TimeUnit.MILLISECONDS);
        }
        return reporter;
    }

    private static ConnectorConfig transformMembership(ConnectorConfig config, Function<Membership, Membership> transformer) {
        return ImmutableConnectorConfig.copyOf(config).withGroup(ImmutableGroupConfig.copyOf(config.group()).withStaticMembership(transformer.apply(config.group().staticMembership())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws Throwable {
        boolean getMemberNumberFromHostname;
        LOGGER.info("Couchbase Elasticsearch Connector version {}", (Object)VersionHelper.getVersionString());
        OptionsParser parser = new OptionsParser();
        OptionSet options = parser.parse(args);
        File configFile = (File)options.valueOf(parser.configFile);
        System.out.println("Reading connector configuration from " + String.valueOf(configFile.getAbsoluteFile()));
        ConnectorConfig config = ConnectorConfig.from(configFile);
        if (config.trustStore().isPresent()) {
            LOGGER.warn("The [truststore] config section is DEPRECATED and will be removed in a future release. Please specify the Couchbase and/or Elasticsearch CA certificates by setting `pathToCaCertificate` in the [couchbase] and/or [elasticsearch] config sections. The files identified by `pathToCaCertificate` should contain one or more certificates in PEM format.");
        }
        DefaultPanicButton panicButton = new DefaultPanicButton();
        boolean watchK8sReplicas = "true".equals(System.getenv("CBES_K8S_WATCH_REPLICAS"));
        boolean bl = getMemberNumberFromHostname = watchK8sReplicas || "true".equals(System.getenv("CBES_K8S_STATEFUL_SET"));
        if (getMemberNumberFromHostname) {
            int memberNumber = StatefulSetInfo.fromHostname().podOrdinal + 1;
            LOGGER.info("Getting group member number from Kubernetes pod hostname: {}", (Object)memberNumber);
            int clusterSize = watchK8sReplicas ? 1024 : config.group().staticMembership().getClusterSize();
            config = ElasticsearchConnector.transformMembership(config, m -> Membership.of(memberNumber, clusterSize));
        }
        try (DefaultKubernetesClient k8sClient = null;){
            if (watchK8sReplicas) {
                k8sClient = new DefaultKubernetesClient();
                LOGGER.info("Activating native Kubernetes integration; connector will use StatefulSet spec to determine group size. This mode requires a Kubernetes service account with 'get' and 'watch', and 'list' permissions for the StatefulSet.");
                int k8sReplicas = ReplicaChangeWatcher.getReplicasAndPanicOnChange((KubernetesClient)k8sClient, panicButton);
                config = ElasticsearchConnector.transformMembership(config, m -> Membership.of(m.getMemberNumber(), k8sReplicas));
            }
            if (watchK8sReplicas || getMemberNumberFromHostname) {
                LOGGER.info("Patched configuration with info from Kubernetes environment; membership = {}", (Object)config.group().staticMembership());
            }
            if (config.group().staticMembership().getClusterSize() > 1024) {
                panicButton.panic("Invalid group size configuration; totalMembers must be <= 1024. Did you forget to set the CBES_TOTAL_MEMBERS environment variable?");
            }
            Duration startupQuietPeriod = watchK8sReplicas ? ReplicaChangeWatcher.startupQuietPeriod() : Duration.ZERO;
            ElasticsearchConnector.run(config, panicButton, startupQuietPeriod);
        }
    }

    public static void run(ConnectorConfig config) throws Throwable {
        new ConnectorRunner(config).run();
    }

    public static void run(ConnectorConfig config, PanicButton panicButton, Duration startupQuietPeriod) throws Throwable {
        new ConnectorRunner(config).panicButton(panicButton).startupQuietPeriod(startupQuietPeriod).run();
    }

    private static void run(ConnectorConfig config, PanicButton panicButton, Duration startupQuietPeriod, Runnable onReady) throws Throwable {
        Throwable fatalError;
        Membership membership = config.group().staticMembership();
        LOGGER.info("Read configuration: {}", (Object)RedactableArgument.redactSystem((Object)config));
        LOGGER.info("Couchbase CA certificate(s): {}", (Object)KeyStoreHelper.describe(config.couchbase().caCert()));
        LOGGER.info("Elasticsearch CA certificate(s): {}", (Object)KeyStoreHelper.describe(config.elasticsearch().caCert()));
        ScheduledExecutorService checkpointExecutor = Executors.newSingleThreadScheduledExecutor();
        DocumentLifecycle.setLogLevel(config.logging().logDocumentLifecycle() ? LogLevel.INFO : LogLevel.DEBUG);
        LogRedaction.setRedactionLevel((RedactionLevel)config.logging().redactionLevel());
        DcpHelper.setRedactionLevel(config.logging().redactionLevel());
        try (Slf4jReporter metricReporter = ElasticsearchConnector.newSlf4jReporter(config.metrics().logInterval());
             HttpServer httpServer = new HttpServer(config.metrics().httpPort(), membership);
             SinkOps esClient = SinkOps.create(config);){
            Cluster cluster = CouchbaseHelper.createCluster(config);
            Bucket bucket = CouchbaseHelper.waitForBucket(cluster, config.couchbase().bucket());
            Set<SeedNode> kvNodes = CouchbaseHelper.getKvNodes(config.couchbase(), bucket);
            ClusterTopologyWithBucket topology = CouchbaseHelper.getTopology(bucket, bucket.environment().timeoutConfig().connectTimeout());
            ClusterIdentifier clusterId = topology.id();
            String clusterUuid = clusterId == null ? "" : clusterId.clusterUuid();
            LOGGER.debug("Connected to Couchbase Server cluster with UUID: {}", (Object)clusterUuid);
            Metrics.commonTags(CbCollections.listOf((Object[])new Tag[]{Tag.of((String)"clusterUuid", (String)clusterUuid), Tag.of((String)"bucket", (String)bucket.name())}));
            boolean storeMetadataInSourceBucket = config.couchbase().metadataBucket().equals(config.couchbase().bucket());
            Bucket metadataBucket = storeMetadataInSourceBucket ? bucket : CouchbaseHelper.waitForBucket(cluster, config.couchbase().metadataBucket());
            Collection metadataCollection = CouchbaseHelper.getMetadataCollection(metadataBucket, config.couchbase());
            CouchbaseCheckpointDao checkpointDao = new CouchbaseCheckpointDao(metadataCollection, config.group().name());
            String bucketUuid = "";
            CheckpointService checkpointService = new CheckpointService("", checkpointDao);
            RequestFactory requestFactory = new RequestFactory((List<TypeConfig>)config.elasticsearch().types(), config.elasticsearch().docStructure(), config.elasticsearch().rejectLog());
            SinkWorkerGroup workers = new SinkWorkerGroup(esClient, checkpointService, requestFactory, ErrorListener.NOOP, config.elasticsearch().bulkRequest());
            Metrics.gauge("write.queue", "Document events currently buffered in memory.", workers, SinkWorkerGroup::getQueueSize);
            Metrics.gauge("es.wait.ms", null, workers, SinkWorkerGroup::getCurrentRequestMillis);
            Metrics.gauge("es.wait.seconds", "Duration of in-flight Elasticsearch bulk request (including any retries). Long duration may indicate connector has stalled.", workers, value -> (double)value.getCurrentRequestMillis() / (double)TimeUnit.SECONDS.toMillis(1L));
            Client dcpClient = DcpHelper.newClient(config.group().name(), config.couchbase(), kvNodes, config.trustStore().orElse(null));
            DcpHelper.initEventListener(dcpClient, panicButton, workers::submit);
            Thread saveCheckpoints = new Thread(checkpointService::save, "save-checkpoints");
            try {
                try {
                    dcpClient.connect().block(config.couchbase().dcp().connectTimeout());
                }
                catch (Throwable t) {
                    panicButton.panic("Failed to establish initial DCP connection within " + String.valueOf(config.couchbase().dcp().connectTimeout()), t);
                }
                int numPartitions = dcpClient.numPartitions();
                Set<Integer> partitions = membership.getPartitions(numPartitions);
                LOGGER.info("Bucket has {} partitions. Membership = {}. Assigned partitions: {}", new Object[]{numPartitions, membership, PartitionSet.from(partitions)});
                if (partitions.isEmpty()) {
                    throw new IllegalArgumentException("There are more workers than Couchbase vbuckets; this worker doesn't have any work to do.");
                }
                checkpointService.init(numPartitions, () -> DcpHelper.getCurrentSeqnosAsMap(dcpClient, partitions, Duration.ofSeconds(5L)));
                ElasticsearchConnector.maybeSetDefaultCheckpoints(config, checkpointDao, "", partitions, kvNodes);
                dcpClient.initializeState(StreamFrom.BEGINNING, StreamTo.INFINITY).block();
                DcpHelper.initSessionState(dcpClient, checkpointService, partitions);
                if (!startupQuietPeriod.isZero()) {
                    LOGGER.info("Entering startup quiet period; sleeping for {} so peers can terminate in case of unsafe scaling.", (Object)startupQuietPeriod);
                    TimeUnit.MILLISECONDS.sleep(startupQuietPeriod.toMillis());
                    LOGGER.info("Startup quiet period complete.");
                }
                checkpointExecutor.scheduleWithFixedDelay(checkpointService::save, 10L, 10L, TimeUnit.SECONDS);
                RuntimeHelper.addShutdownHook(saveCheckpoints);
                panicButton.addPrePanicHook(() -> RuntimeHelper.removeShutdownHook(saveCheckpoints));
                try {
                    LOGGER.debug("Opening DCP streams for partitions: {}", partitions);
                    dcpClient.startStreaming(partitions).block();
                }
                catch (RuntimeException e) {
                    ThrowableHelper.propagateCauseIfPossible(e, InterruptedException.class);
                    throw e;
                }
                httpServer.start();
                if (config.metrics().httpPort() >= 0) {
                    LOGGER.info("Prometheus metrics available at http://localhost:{}/metrics/prometheus", (Object)httpServer.getBoundPort());
                    LOGGER.info("Dropwizard metrics available at http://localhost:{}/metrics/dropwizard?pretty", (Object)httpServer.getBoundPort());
                } else {
                    LOGGER.info("Metrics HTTP server is disabled. Edit the [metrics] 'httpPort' config property to enable.");
                }
                LOGGER.info("Elasticsearch connector startup complete.");
                onReady.run();
                fatalError = workers.awaitFatalError();
                LOGGER.error("Terminating due to fatal error from worker", fatalError);
            }
            catch (InterruptedException shutdownRequest) {
                LOGGER.info("Graceful shutdown requested. Saving checkpoints and cleaning up.");
                checkpointService.save();
                throw shutdownRequest;
            }
            catch (Throwable t) {
                LOGGER.error("Terminating due to fatal error during setup", t);
                throw t;
            }
            finally {
                RuntimeHelper.removeShutdownHook(saveCheckpoints);
                checkpointExecutor.shutdown();
                metricReporter.stop();
                dcpClient.disconnect().block();
                workers.close();
                checkpointExecutor.awaitTermination(10L, TimeUnit.SECONDS);
                cluster.disconnect();
            }
        }
        TimeUnit.MILLISECONDS.sleep(500L);
        throw fatalError;
    }

    private static void maybeSetDefaultCheckpoints(ConnectorConfig config, CheckpointDao checkpointDao, String bucketUuid, Set<Integer> paritionsAssignedToMe, Set<SeedNode> kvNodes) {
        Map<Integer, Checkpoint> defaults;
        Map<Integer, Checkpoint> existingCheckpoints = checkpointDao.loadExisting(bucketUuid, paritionsAssignedToMe);
        if (existingCheckpoints.keySet().equals(paritionsAssignedToMe)) {
            LOGGER.info("defaultCheckpoint: Each assigned partitions has a checkpoint; default not required.");
            return;
        }
        CouchbaseConfig.DefaultCheckpoint defaultCheckpoint = config.couchbase().defaultCheckpoint();
        switch (defaultCheckpoint) {
            case NOW: {
                defaults = CheckpointClear.getNowForAllPartitions(config, kvNodes);
                break;
            }
            case ZERO: {
                defaults = new HashMap<Integer, Checkpoint>();
                paritionsAssignedToMe.forEach(p -> defaults.put((Integer)p, Checkpoint.ZERO));
                break;
            }
            default: {
                throw new RuntimeException("Unexpected default checkpoint type: " + String.valueOf((Object)defaultCheckpoint));
            }
        }
        defaults.keySet().retainAll(paritionsAssignedToMe);
        defaults.keySet().removeAll(existingCheckpoints.keySet());
        LOGGER.info("defaultCheckpoint: At least one assigned partition does not have a checkpoint. Creating '{}' checkpoints for partitions: {}", (Object)defaultCheckpoint, (Object)PartitionSet.from(defaults.keySet()));
        LOGGER.debug("defaultCheckpoint: Saving '{}' checkpoints: {}", (Object)defaultCheckpoint, new TreeMap<Integer, Checkpoint>(defaults));
        checkpointDao.save(bucketUuid, defaults);
    }

    public static class ConnectorRunner {
        private final ConnectorConfig config;
        private PanicButton panicButton = new DefaultPanicButton();
        private Duration startupQuietPeriod = Duration.ZERO;
        private Runnable onReady = () -> {};

        public ConnectorRunner(ConnectorConfig config) {
            this.config = config;
        }

        public ConnectorRunner panicButton(PanicButton panicButton) {
            this.panicButton = panicButton;
            return this;
        }

        public ConnectorRunner onReady(Runnable onReady) {
            this.onReady = onReady;
            return this;
        }

        public ConnectorRunner startupQuietPeriod(Duration startupQuietPeriod) {
            this.startupQuietPeriod = startupQuietPeriod;
            return this;
        }

        public void run() throws Throwable {
            ElasticsearchConnector.run(this.config, this.panicButton, this.startupQuietPeriod, this.onReady);
        }
    }

    private static class OptionsParser
    extends AbstractCliCommand.CommonParser {
        private OptionsParser() {
        }
    }
}

