/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch;

import com.couchbase.connector.config.common.ClientCertConfig;
import com.couchbase.connector.config.common.TrustStoreConfig;
import com.couchbase.connector.config.es.ConnectorConfig;
import com.couchbase.connector.config.es.ElasticCloudConfig;
import com.couchbase.connector.config.es.ElasticsearchConfig;
import com.couchbase.connector.elasticsearch.ElasticsearchSinkOps;
import com.couchbase.connector.elasticsearch.Metrics;
import com.couchbase.connector.util.KeyStoreHelper;
import com.google.common.collect.Iterables;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchHelper.class);

    private ElasticsearchHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static ElasticsearchSinkOps newElasticsearchSinkOps(ConnectorConfig config) {
        ElasticsearchConfig elasticsearchConfig = config.elasticsearch();
        TrustStoreConfig trustStoreConfig = config.trustStore().orElse(null);
        Supplier<KeyStore> trustStoreSupplier = KeyStoreHelper.trustStoreFrom("Elasticsearch", elasticsearchConfig.caCert(), trustStoreConfig);
        return new ElasticsearchSinkOps(ElasticsearchHelper.newRestClient(elasticsearchConfig.hosts(), elasticsearchConfig.username(), elasticsearchConfig.password(), elasticsearchConfig.secureConnection(), trustStoreSupplier, elasticsearchConfig.clientCert(), elasticsearchConfig.elasticCloud(), elasticsearchConfig.bulkRequest().timeout()), elasticsearchConfig.bulkRequest().timeout());
    }

    public static RestClientBuilder newRestClient(List<HttpHost> hosts, String username, String password, boolean secureConnection, Supplier<KeyStore> trustStore, ClientCertConfig clientCert, ElasticCloudConfig elasticCloud, Duration bulkRequestTimeout) {
        int connectTimeoutMillis = (int)TimeUnit.SECONDS.toMillis(5L);
        int socketTimeoutMillis = (int)Math.max(TimeUnit.SECONDS.toMillis(60L), bulkRequestTimeout.toMillis() + TimeUnit.SECONDS.toMillis(3L));
        LOGGER.info("Elasticsearch client connect timeout = {}ms; socket timeout={}ms", (Object)connectTimeoutMillis, (Object)socketTimeoutMillis);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        SSLContext sslContext = !secureConnection ? null : ElasticsearchHelper.newSslContext(trustStore.get(), clientCert);
        return RestClient.builder((HttpHost[])((HttpHost[])Iterables.toArray(hosts, HttpHost.class))).setHttpClientConfigCallback(arg_0 -> ElasticsearchHelper.lambda$newRestClient$0(sslContext, clientCert, elasticCloud, (CredentialsProvider)credentialsProvider, password, arg_0)).setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(connectTimeoutMillis).setSocketTimeout(socketTimeoutMillis)).setFailureListener(new RestClient.FailureListener(){

            public void onFailure(Node host) {
                Metrics.elasticsearchHostOffline().increment();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SSLContext newSslContext(KeyStore trustStore, ClientCertConfig clientCert) {
        try {
            SSLContextBuilder builder = SSLContexts.custom().loadTrustMaterial(trustStore, null);
            if (clientCert.use()) {
                String passwordString = clientCert.password();
                char[] pw = passwordString == null ? null : passwordString.toCharArray();
                try {
                    builder.loadKeyMaterial(clientCert.getKeyStore(), pw);
                }
                finally {
                    if (pw != null) {
                        Arrays.fill(pw, '\u0000');
                    }
                }
            }
            return builder.build();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$newRestClient$0(SSLContext sslContext, ClientCertConfig clientCert, ElasticCloudConfig elasticCloud, CredentialsProvider credentialsProvider, String password, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.setSSLContext(sslContext);
        if (!clientCert.use() && !elasticCloud.enabled()) {
            httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        }
        if (elasticCloud.enabled()) {
            httpClientBuilder.setDefaultHeaders(List.of(new BasicHeader("Authorization", "ApiKey " + password)));
        }
        return httpClientBuilder;
    }
}

