/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.MgetResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkResponseItem;
import co.elastic.clients.elasticsearch.core.mget.MultiGetResponseItem;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.connector.elasticsearch.ElasticsearchBulkRequestBuilder;
import com.couchbase.connector.elasticsearch.io.BackoffPolicy;
import com.couchbase.connector.elasticsearch.io.BackoffPolicyBuilder;
import com.couchbase.connector.elasticsearch.sink.Operation;
import com.couchbase.connector.elasticsearch.sink.SinkBulkResponse;
import com.couchbase.connector.elasticsearch.sink.SinkBulkResponseItem;
import com.couchbase.connector.elasticsearch.sink.SinkErrorCause;
import com.couchbase.connector.elasticsearch.sink.SinkOps;
import com.couchbase.connector.elasticsearch.sink.SinkTestOps;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchSinkOps
implements SinkOps,
SinkTestOps {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchSinkOps.class);
    private static final JsonMapper jsonMapper = new JsonMapper();
    private final ElasticsearchClient client;
    private final RestClient lowLevelClient;
    private final String bulkRequestTimeoutString;

    public ElasticsearchSinkOps(RestClientBuilder restClientBuilder, Duration bulkRequestTimeout) {
        this.lowLevelClient = restClientBuilder.build();
        this.bulkRequestTimeoutString = bulkRequestTimeout.toMillis() + "ms";
        RestClientTransport transport = new RestClientTransport(this.lowLevelClient, (JsonpMapper)new JacksonJsonpMapper((ObjectMapper)jsonMapper));
        this.client = new ElasticsearchClient((ElasticsearchTransport)transport);
    }

    @Override
    public SinkBulkResponse bulk(List<Operation> operations) throws IOException {
        ElasticsearchBulkRequestBuilder requestBuilder = new ElasticsearchBulkRequestBuilder();
        operations.forEach(it -> it.addTo(requestBuilder));
        BulkRequest request = requestBuilder.build(this.bulkRequestTimeoutString);
        final BulkResponse wrapped = this.client.bulk(request);
        return new SinkBulkResponse(){

            @Override
            public Duration ingestTook() {
                return wrapped.ingestTook() == null ? Duration.ZERO : Duration.ofNanos(wrapped.ingestTook());
            }

            @Override
            public List<SinkBulkResponseItem> items() {
                return CbCollections.transform((Iterable)wrapped.items(), it -> new SinkBulkResponseItem((BulkResponseItem)it){
                    final /* synthetic */ BulkResponseItem val$it;
                    {
                        this.val$it = bulkResponseItem;
                    }

                    @Override
                    public int status() {
                        return this.val$it.status();
                    }

                    @Override
                    public SinkErrorCause error() {
                        return this.val$it.error() == null ? null : new SinkErrorCause(){

                            @Override
                            public @Nullable String reason() {
                                return val$it.error().reason();
                            }

                            public String toString() {
                                return val$it.error().toString();
                            }
                        };
                    }
                });
            }
        };
    }

    @Override
    public ObjectNode info() {
        ObjectNode objectNode;
        block8: {
            Response response = this.lowLevelClient.performRequest(new Request("GET", "/"));
            InputStream is = response.getEntity().getContent();
            try {
                objectNode = (ObjectNode)jsonMapper.readTree(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return objectNode;
    }

    @Override
    public Optional<JsonNode> getDocument(String index, String id, @Nullable String routing) {
        try {
            Object url = CoreHttpPath.formatPath((String)"{}/_doc/{}", (String[])new String[]{index, id});
            if (routing != null) {
                url = (String)url + CoreHttpPath.formatPath((String)"?routing={}", (String[])new String[]{routing});
            }
            return Optional.of(this.doGet((String)url));
        }
        catch (ResponseException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long countDocuments(String index) {
        try {
            JsonNode response = this.doGet(index + "/_count");
            return response.get("count").longValue();
        }
        catch (ResponseException e) {
            return -1L;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteAllIndexes() {
        try {
            BackoffPolicy backoffPolicy = BackoffPolicyBuilder.constantBackoff(Duration.ofSeconds(1L)).limit(10).build();
            for (String index : ElasticsearchSinkOps.retryUntilSuccess(backoffPolicy, this::indexNames)) {
                if (index.startsWith(".")) continue;
                JsonNode deletionResponse = this.doDelete(index);
                System.out.println("Deleted index '" + index + "' : " + String.valueOf(deletionResponse));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<SinkTestOps.MultiGetItem> multiGet(String index, Collection<String> ids) {
        ArrayList<SinkTestOps.MultiGetItem> result = new ArrayList<SinkTestOps.MultiGetItem>();
        try {
            MgetResponse response = this.client.mget(builder -> builder.index(index).ids(List.copyOf(Set.copyOf(ids))), JsonNode.class);
            for (MultiGetResponseItem item : response.docs()) {
                if (item.isFailure()) {
                    result.add(new SinkTestOps.MultiGetItem(item.failure().id(), item.failure().error().reason(), null));
                    continue;
                }
                result.add(new SinkTestOps.MultiGetItem(item.result().id(), null, (JsonNode)item.result().source()));
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JsonNode doDelete(String endpoint) throws IOException {
        Response response = this.lowLevelClient.performRequest(new Request("DELETE", endpoint));
        try (InputStream is = response.getEntity().getContent();){
            JsonNode jsonNode = jsonMapper.readTree(is);
            return jsonNode;
        }
    }

    private static <T> T retryUntilSuccess(BackoffPolicy backoffPolicy, Callable<T> lambda) {
        Iterator delays = backoffPolicy.iterator();
        while (true) {
            try {
                return lambda.call();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (delays.hasNext()) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(((Duration)delays.next()).toMillis());
                    }
                    catch (InterruptedException interrupted) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(interrupted);
                    }
                    continue;
                }
                throw new RuntimeException(new TimeoutException());
            }
            break;
        }
    }

    private List<String> indexNames() {
        try {
            JsonNode response = this.doGet("_stats");
            return ImmutableList.copyOf((Iterator)response.path("indices").fieldNames());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JsonNode doGet(String endpoint) throws IOException {
        Response response = this.lowLevelClient.performRequest(new Request("GET", endpoint));
        try (InputStream is = response.getEntity().getContent();){
            JsonNode jsonNode = jsonMapper.readTree(is);
            return jsonNode;
        }
    }

    @Override
    public void close() throws IOException {
        ((ElasticsearchTransport)this.client._transport()).close();
    }
}

