/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch;

import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.util.Deadline;
import com.couchbase.client.dcp.util.Version;
import com.couchbase.connector.elasticsearch.io.MoreBackoffPolicies;
import com.couchbase.connector.util.ThrowableHelper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.Method;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ElasticsearchVersionSniffer {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchVersionSniffer.class);
    private final CloseableHttpAsyncClient httpClient;
    private static final JsonMapper jsonMapper = (JsonMapper)JsonMapper.builder().build();

    public ElasticsearchVersionSniffer(CloseableHttpAsyncClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient);
    }

    public FlavorAndVersion sniff(List<HttpHost> hosts, Duration timeout) {
        Deadline deadline = Deadline.of((Duration)timeout);
        Iterator retryDelays = MoreBackoffPolicies.truncatedExponentialBackoff(Duration.ofSeconds(1L), Duration.ofMinutes(1L)).iterator();
        block2: while (true) {
            CopyOnWriteArrayList failures = new CopyOnWriteArrayList();
            FlavorAndVersion result = (FlavorAndVersion)Flux.fromIterable(hosts).flatMap(host -> this.sniff((HttpHost)host).onErrorResume(t -> {
                failures.add(t);
                return Mono.empty();
            })).blockFirst(timeout);
            if (result != null) {
                this.check(result);
                return result;
            }
            if (deadline.exceeded()) {
                throw new RuntimeException("Failed to connect to sink within " + String.valueOf(timeout));
            }
            Duration delay = (Duration)retryDelays.next();
            Iterator iterator = failures.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block2;
                Throwable t = (Throwable)iterator.next();
                log.warn("Failed to connect to sink. Retrying in {}", (Object)delay, (Object)t);
                if (ThrowableHelper.hasCause(t, ConnectionClosedException.class, new Class[0])) {
                    log.warn("  Troubleshooting tip: If the sink connection failure persists, and the sink is configured to require TLS, then make sure the connector is also configured to use secure connections.");
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(delay.toMillis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
            break;
        }
    }

    private void check(FlavorAndVersion result) {
        log.info("Detected sink: {}", (Object)result);
        Version version = result.version;
        Version required = result.flavor.minCompatible;
        Version recommended = result.flavor.minRecommended;
        if (version.compareTo(required) < 0) {
            throw new RuntimeException(String.valueOf((Object)result.flavor) + " version " + String.valueOf(required) + " or later is required; actual version is " + String.valueOf(version));
        }
        if (version.compareTo(recommended) < 0) {
            log.warn(String.valueOf((Object)result.flavor) + " version " + String.valueOf(version) + " is lower than recommended minimum version " + String.valueOf(recommended) + ".");
        }
    }

    private Mono<SimpleHttpResponse> execReactive(Method method, HttpHost host, String path) {
        return Mono.create(sink -> {
            AtomicReference<Future> future = new AtomicReference<Future>();
            sink.onCancel(() -> {
                Future f = (Future)future.get();
                if (f != null) {
                    f.cancel(true);
                }
            });
            SimpleHttpRequest request = SimpleHttpRequest.create((Method)method, (HttpHost)host, (String)path);
            future.set(this.httpClient.execute(request, (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

                public void completed(SimpleHttpResponse result) {
                    sink.success((Object)result);
                }

                public void failed(Exception ex) {
                    sink.error((Throwable)ex);
                }

                public void cancelled() {
                    sink.error((Throwable)new CancellationException("The HTTP request was cancelled."));
                }
            }));
        });
    }

    private Mono<FlavorAndVersion> sniff(HttpHost host) {
        log.info("Getting sink flavor and version from {}", (Object)RedactableArgument.redactSystem((Object)host));
        return this.execReactive(Method.GET, host, "/").map(response -> {
            try {
                JsonNode info = jsonMapper.readTree(response.getBodyBytes());
                return new FlavorAndVersion(Flavor.of(info.at("/version/distribution").textValue()), Version.parseVersion((String)info.at("/version/number").textValue()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static class FlavorAndVersion {
        public final Flavor flavor;
        public final Version version;

        public FlavorAndVersion(Flavor flavor, Version version) {
            this.flavor = Objects.requireNonNull(flavor);
            this.version = Objects.requireNonNull(version);
        }

        public String toString() {
            return String.valueOf((Object)this.flavor) + " " + String.valueOf(this.version);
        }
    }

    public static enum Flavor {
        ELASTICSEARCH("Elasticsearch", new Version(7, 14, 0), new Version(7, 17, 5)),
        OPENSEARCH("OpenSearch", new Version(1, 3, 3), new Version(2, 6, 0));

        private final String prettyName;
        private final Version minCompatible;
        private final Version minRecommended;

        private Flavor(String prettyName, Version minCompatible, Version minRecommended) {
            this.minCompatible = Objects.requireNonNull(minCompatible);
            this.minRecommended = Objects.requireNonNull(minRecommended);
            this.prettyName = Objects.requireNonNull(prettyName);
        }

        public String toString() {
            return this.prettyName;
        }

        public Version minCompatible() {
            return this.minCompatible;
        }

        public Version minRecommended() {
            return this.minRecommended;
        }

        public static Flavor of(@Nullable String s) {
            return "opensearch".equals(s) ? OPENSEARCH : ELASTICSEARCH;
        }
    }
}

