/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.json.MetricsModule;
import com.couchbase.client.dcp.metrics.DefaultDropwizardConfig;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics {
    private static final Logger log = LoggerFactory.getLogger(Metrics.class);
    public static final HierarchicalNameMapper PRETTY_TAGS = (id, convention) -> {
        Object base = id.getConventionName(convention);
        if (((String)base).startsWith("dcp")) {
            base = "dcp." + Character.toLowerCase(((String)base).charAt(3)) + ((String)base).substring(4);
        } else if (((String)base).startsWith("cbes")) {
            base = PREFIX + Character.toLowerCase(((String)base).charAt(4)) + ((String)base).substring(5);
        } else if (((String)base).startsWith("jvm")) {
            base = "jvm." + Character.toLowerCase(((String)base).charAt(3)) + ((String)base).substring(4);
        }
        List tags = id.getConventionTags(convention);
        if (tags.isEmpty()) {
            return base;
        }
        return (String)base + "{" + tags.stream().map(t -> t.getKey() + "=" + t.getValue()).map(nameSegment -> nameSegment.replace(" ", "_")).collect(Collectors.joining(",")) + "}";
    };
    private static final PrometheusMeterRegistry prometheusRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
    private static final MetricRegistry dropwizardBackingRegistry;
    private static final DropwizardMeterRegistry dropwizardRegistry;
    private static final String PREFIX = "cbes.";
    private static final CompositeMeterRegistry registry;
    private static final String BYTES = "bytes";
    private static final Counter bytesMeter;
    private static final Counter rejectionCounter;
    private static final Counter rejectionLogFailureCounter;
    private static final Counter indexingRetryCounter;
    private static final Timer bulkIndexingTimer;
    private static final Timer retryDelayTimer;
    private static final Counter bulkRetriesCounter;
    private static final Counter httpFailures;
    private static final Timer latencyTimer;
    private static final ObjectMapper mapper;

    public static CompositeMeterRegistry registry() {
        return registry;
    }

    public static void commonTags(Iterable<Tag> tags) {
        prometheusRegistry.config().commonTags(tags);
        dropwizardRegistry.config().commonTags(tags);
    }

    private Metrics() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static Counter counter(String name, String description) {
        return Metrics.counter(name, description, null);
    }

    public static Counter counter(String name, String description, String unit) {
        return Counter.builder((String)(PREFIX + name)).baseUnit(unit).description(description).register((MeterRegistry)registry);
    }

    public static Timer timer(String name, String description) {
        return Timer.builder((String)(PREFIX + name)).description(description).register((MeterRegistry)registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T gauge(String name, String description, T stateObject, ToDoubleFunction<T> valueFunction) {
        Class<Metrics> clazz = Metrics.class;
        synchronized (Metrics.class) {
            registry.remove(new Meter.Id(PREFIX + name, Tags.empty(), null, description, Meter.Type.GAUGE));
            Gauge.builder((String)(PREFIX + name), stateObject, valueFunction).description(description).register((MeterRegistry)registry);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return stateObject;
        }
    }

    public static <T> T cachedGauge(String name, String description, T stateObject, ToDoubleFunction<T> valueFunction, Duration expiration) {
        Supplier memoized = Suppliers.memoizeWithExpiration(() -> valueFunction.applyAsDouble(stateObject), (long)expiration.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        return (T)Metrics.gauge(name, description, stateObject, arg_0 -> Metrics.lambda$cachedGauge$4((java.util.function.Supplier)memoized, arg_0));
    }

    public static <T> T cachedGauge(String name, String description, T stateObject, ToDoubleFunction<T> valueFunction) {
        Duration DEFAULT_EXPIRY = Duration.ofSeconds(1L);
        return Metrics.cachedGauge(name, description, stateObject, valueFunction, DEFAULT_EXPIRY);
    }

    public static Counter bytesCounter() {
        return bytesMeter;
    }

    public static Counter rejectionLogFailureCounter() {
        return rejectionLogFailureCounter;
    }

    public static Counter rejectionCounter() {
        return rejectionCounter;
    }

    public static Counter indexingRetryCounter() {
        return indexingRetryCounter;
    }

    public static Timer indexTimePerDocument() {
        return bulkIndexingTimer;
    }

    public static Counter bulkRetriesCounter() {
        return bulkRetriesCounter;
    }

    public static Counter elasticsearchHostOffline() {
        return httpFailures;
    }

    public static Timer retryDelayTimer() {
        return retryDelayTimer;
    }

    public static Timer latencyTimer() {
        return latencyTimer;
    }

    public static String toJson() {
        return Metrics.toJson(false);
    }

    public static String toJson(boolean pretty) {
        Stopwatch timer = Stopwatch.createStarted();
        try {
            String string = (pretty ? mapper.writerWithDefaultPrettyPrinter() : mapper.writer()).writeValueAsString((Object)Metrics.toJsonNode());
            return string;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        finally {
            log.info("Serializing metrics as JSON took " + String.valueOf(timer));
        }
    }

    public static JsonNode toJsonNode() {
        return (JsonNode)mapper.convertValue((Object)dropwizardBackingRegistry, JsonNode.class);
    }

    public static String toPrometheusExpositionFormat() {
        return prometheusRegistry.scrape();
    }

    public static MetricRegistry dropwizardRegistry() {
        return dropwizardBackingRegistry;
    }

    private static /* synthetic */ double lambda$cachedGauge$4(java.util.function.Supplier memoized, Object value) {
        return (Double)memoized.get();
    }

    static {
        prometheusRegistry.config().meterFilter(MeterFilter.denyNameStartsWith((String)"cbes.es.wait.ms"));
        dropwizardBackingRegistry = new MetricRegistry();
        dropwizardRegistry = new DropwizardMeterRegistry((DropwizardConfig)new DefaultDropwizardConfig(), dropwizardBackingRegistry, PRETTY_TAGS, Clock.SYSTEM){

            protected Double nullGaugeValue() {
                return null;
            }
        };
        registry = new CompositeMeterRegistry();
        registry.add((MeterRegistry)prometheusRegistry);
        registry.add((MeterRegistry)dropwizardRegistry);
        new ClassLoaderMetrics().bindTo((MeterRegistry)registry);
        new JvmMemoryMetrics().bindTo((MeterRegistry)registry);
        new JvmGcMetrics().bindTo((MeterRegistry)registry);
        new ProcessorMetrics().bindTo((MeterRegistry)registry);
        new JvmThreadMetrics().bindTo((MeterRegistry)registry);
        bytesMeter = Metrics.counter("throughput.bytes", "An estimate of the number of bytes the connector has written to Elasticsearch.", BYTES);
        rejectionCounter = Metrics.counter("doc.rejected", "Permanent indexing failure; usually result in an entry being added to the rejection log Elasticsearch index.");
        rejectionLogFailureCounter = Metrics.counter("rejection.log.fail", "Failure to add a record to the rejection log Elasticsearch index.");
        indexingRetryCounter = Metrics.counter("doc.write.retry", "Failure to write an individual document. (For each `bulkRetry` event, one or more `docWriteRetry` events are recorded, indicating how many failures there were in the bulk request.)");
        bulkIndexingTimer = Metrics.timer("bulk.index.per.doc", "Duration of an Elasticsearch bulk request (including retries), divided by the number of items in the bulk request.");
        retryDelayTimer = Metrics.timer("retry.delay", "Time spent waiting after a temporary indexing failure before the request is retried.");
        bulkRetriesCounter = Metrics.counter("bulk.retry", "Elasticsearch bulk request retry due to a temporary failure.");
        httpFailures = Metrics.counter("es.conn.fail", "Failed Elasticsearch connection attempts.");
        latencyTimer = Metrics.timer("latency", "The time between when the connector is notified of a database change and when the change is written to Elasticsearch.");
        mapper = new ObjectMapper();
        mapper.registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false));
    }
}

