/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch;

import com.couchbase.connector.elasticsearch.sink.DeleteOperation;
import com.couchbase.connector.elasticsearch.sink.IndexOperation;
import com.couchbase.connector.elasticsearch.sink.SinkBulkRequestBuilder;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.DeleteOperation;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.opensearch.client.util.ObjectBuilder;

public class OpenSearchBulkRequestBuilder
implements SinkBulkRequestBuilder {
    private final List<BulkOperation> operations = new ArrayList<BulkOperation>();

    public BulkRequest build(String timeout) {
        return new BulkRequest.Builder().operations(this.operations).timeout(time -> time.time(timeout)).build();
    }

    @Override
    public void add(DeleteOperation operation) {
        this.operations.add((BulkOperation)new BulkOperation.Builder().delete(op -> (ObjectBuilder)((DeleteOperation.Builder)op.index(operation.getIndex())).id(operation.getEvent().getKey())).build());
    }

    @Override
    public void add(IndexOperation operation) {
        this.operations.add((BulkOperation)new BulkOperation.Builder().index(op -> (ObjectBuilder)((IndexOperation.Builder)((IndexOperation.Builder)((IndexOperation.Builder)op.index(operation.getIndex())).id(operation.getEvent().getKey())).document(operation.document()).pipeline(operation.pipeline())).routing(operation.routing())).build());
    }
}

