/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch;

import com.couchbase.client.core.util.CbCollections;
import com.couchbase.connector.config.ConfigException;
import com.couchbase.connector.config.common.ClientCertConfig;
import com.couchbase.connector.config.es.ConnectorConfig;
import com.couchbase.connector.config.es.ElasticsearchConfig;
import com.couchbase.connector.elasticsearch.Metrics;
import com.couchbase.connector.elasticsearch.OpenSearchSinkOps;
import com.couchbase.connector.util.KeyStoreHelper;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TimeValue;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.aws.AwsSdk2Transport;
import org.opensearch.client.transport.aws.AwsSdk2TransportOptions;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5Transport;
import org.opensearch.client.transport.httpclient5.internal.Node;
import org.opensearch.client.transport.httpclient5.internal.NodeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;

public class OpenSearchHelper {
    private static final Logger log = LoggerFactory.getLogger(OpenSearchHelper.class);

    private OpenSearchHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    private static Duration socketTimeout(ConnectorConfig config) {
        Duration bulkRequestTimeout = config.elasticsearch().bulkRequest().timeout();
        return Duration.ofMillis(Math.max(TimeUnit.SECONDS.toMillis(60L), bulkRequestTimeout.toMillis() + TimeUnit.SECONDS.toMillis(3L)));
    }

    private static Duration connectTimeout(ConnectorConfig config) {
        return Duration.ofSeconds(10L);
    }

    private static Duration connectionAcquisitionTimeout(ConnectorConfig config) {
        return OpenSearchHelper.connectTimeout(config).multipliedBy(2L);
    }

    private static Duration connectionIdleTime(ConnectorConfig config) {
        return Duration.ofSeconds(10L);
    }

    public static CloseableHttpAsyncClient newHttpClient(ConnectorConfig config) {
        int socketTimeoutMillis = (int)OpenSearchHelper.socketTimeout(config).toMillis();
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setSoTimeout(socketTimeoutMillis, TimeUnit.MILLISECONDS).build();
        TlsStrategy tlsStrategy = !config.elasticsearch().secureConnection() ? null : ClientTlsStrategyBuilder.create().setSslContext(OpenSearchHelper.sslContext(config)).build();
        PoolingAsyncClientConnectionManager cm = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(tlsStrategy).build();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(config.elasticsearch().username(), config.elasticsearch().password().toCharArray());
        CloseableHttpAsyncClient client = HttpAsyncClients.custom().setConnectionManager((AsyncClientConnectionManager)cm).setIOReactorConfig(ioReactorConfig).evictExpiredConnections().evictIdleConnections(TimeValue.ofMilliseconds((long)OpenSearchHelper.connectionIdleTime(config).toMillis())).setDefaultCredentialsProvider((authScope, context) -> credentials).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(OpenSearchHelper.connectTimeout(config).toMillis(), TimeUnit.MILLISECONDS).setConnectionRequestTimeout(OpenSearchHelper.connectionAcquisitionTimeout(config).toMillis(), TimeUnit.MILLISECONDS).build()).build();
        client.start();
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SSLContext sslContext(ConnectorConfig config) {
        try {
            KeyStore trustStore = KeyStoreHelper.trustStoreFrom("Elasticsearch", config.elasticsearch().caCert(), config.trustStore().orElse(null)).get();
            SSLContextBuilder builder = SSLContexts.custom().loadTrustMaterial(trustStore, null);
            ClientCertConfig clientCert = config.elasticsearch().clientCert();
            if (clientCert.use()) {
                String passwordString = clientCert.password();
                char[] pw = passwordString == null ? null : passwordString.toCharArray();
                try {
                    builder.loadKeyMaterial(clientCert.getKeyStore(), pw);
                }
                finally {
                    if (pw != null) {
                        Arrays.fill(pw, '\u0000');
                    }
                }
            }
            return builder.build();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static HttpHost toHttpClient5(org.apache.http.HttpHost host) {
        return new HttpHost(host.getSchemeName(), host.getHostName(), host.getPort());
    }

    public static List<HttpHost> hosts(ElasticsearchConfig config) {
        return CbCollections.transform(config.hosts(), it -> OpenSearchHelper.toHttpClient5(it));
    }

    public static OpenSearchSinkOps newAwsOpenSearchSinkOps(ConnectorConfig config) {
        return new OpenSearchSinkOps(new OpenSearchClient(OpenSearchHelper.newAwsTransport(config)), config.elasticsearch().bulkRequest().timeout());
    }

    private static OpenSearchTransport newAwsTransport(ConnectorConfig config) {
        SdkHttpClient awsHttpClient = ApacheHttpClient.builder().connectionTimeout(OpenSearchHelper.connectTimeout(config)).connectionAcquisitionTimeout(OpenSearchHelper.connectionAcquisitionTimeout(config)).socketTimeout(OpenSearchHelper.socketTimeout(config)).build();
        if (config.elasticsearch().hosts().size() != 1) {
            throw new ConfigException("Must specify exactly one host when connecting to Amazon OpenSearch Service.");
        }
        int port = ((org.apache.http.HttpHost)config.elasticsearch().hosts().get(0)).getPort();
        if (port != -1 && port != 443) {
            log.warn("Ignoring non-standard port ({}) in Amazon OpenSearch Service address.", (Object)port);
        }
        String host = ((org.apache.http.HttpHost)config.elasticsearch().hosts().get(0)).getHostName();
        return new AwsSdk2Transport(awsHttpClient, host, Region.of((String)config.elasticsearch().aws().region()), AwsSdk2TransportOptions.builder().build());
    }

    public static OpenSearchSinkOps newOpenSearchSinkOps(CloseableHttpAsyncClient httpClient, ConnectorConfig config) {
        return new OpenSearchSinkOps(new OpenSearchClient(OpenSearchHelper.newApacheHttpClientTransport(httpClient, config)), config.elasticsearch().bulkRequest().timeout());
    }

    private static OpenSearchTransport newApacheHttpClientTransport(CloseableHttpAsyncClient httpClient, ConnectorConfig config) {
        List nodes = CbCollections.transform(config.elasticsearch().hosts(), it -> new Node(OpenSearchHelper.toHttpClient5(it)));
        return new ApacheHttpClient5Transport(httpClient, new Header[0], nodes, (JsonpMapper)new JacksonJsonpMapper(), null, "", new ApacheHttpClient5Transport.FailureListener(){

            public void onFailure(Node node) {
                Metrics.elasticsearchHostOffline().increment();
            }
        }, NodeSelector.ANY, false, true, true);
    }
}

