/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch;

import com.couchbase.client.core.util.CbCollections;
import com.couchbase.connector.elasticsearch.OpenSearchBulkRequestBuilder;
import com.couchbase.connector.elasticsearch.sink.Operation;
import com.couchbase.connector.elasticsearch.sink.SinkBulkResponse;
import com.couchbase.connector.elasticsearch.sink.SinkBulkResponseItem;
import com.couchbase.connector.elasticsearch.sink.SinkErrorCause;
import com.couchbase.connector.elasticsearch.sink.SinkOps;
import com.couchbase.connector.elasticsearch.sink.SinkTestOps;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.opensearch.client.ResponseException;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpDeserializerBase;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.CountResponse;
import org.opensearch.client.opensearch.core.GetResponse;
import org.opensearch.client.opensearch.core.InfoRequest;
import org.opensearch.client.opensearch.core.MgetResponse;
import org.opensearch.client.opensearch.core.bulk.BulkResponseItem;
import org.opensearch.client.opensearch.core.mget.MultiGetResponseItem;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;

public class OpenSearchSinkOps
implements SinkOps,
SinkTestOps {
    private final OpenSearchClient client;
    private final String bulkRequestTimeoutString;
    private static final JsonpMapper jsonpMapper = new JacksonJsonpMapper();

    public OpenSearchSinkOps(OpenSearchClient client, Duration bulkRequestTimeout) {
        this.client = Objects.requireNonNull(client);
        this.bulkRequestTimeoutString = bulkRequestTimeout.toMillis() + "ms";
    }

    @Override
    public ObjectNode info() {
        try {
            JsonpDeserializerBase<ObjectNode> deserializer = new JsonpDeserializerBase<ObjectNode>(EnumSet.allOf(JsonParser.Event.class)){

                public ObjectNode deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
                    return (ObjectNode)mapper.deserialize(parser, ObjectNode.class);
                }
            };
            SimpleEndpoint infoEndpoint = new SimpleEndpoint(request -> "GET", request -> "/", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, (JsonpDeserializer)deserializer);
            return (ObjectNode)((OpenSearchTransport)this.client._transport()).performRequest((Object)InfoRequest._INSTANCE, (Endpoint)infoEndpoint, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SinkBulkResponse bulk(List<Operation> operations) throws IOException {
        OpenSearchBulkRequestBuilder requestBuilder = new OpenSearchBulkRequestBuilder();
        operations.forEach(it -> it.addTo(requestBuilder));
        BulkRequest request = requestBuilder.build(this.bulkRequestTimeoutString);
        final BulkResponse wrapped = this.client.bulk(request);
        return new SinkBulkResponse(){

            @Override
            public Duration ingestTook() {
                return wrapped.ingestTook() == null ? Duration.ZERO : Duration.ofNanos(wrapped.ingestTook());
            }

            @Override
            public List<SinkBulkResponseItem> items() {
                return CbCollections.transform((Iterable)wrapped.items(), it -> new SinkBulkResponseItem((BulkResponseItem)it){
                    final /* synthetic */ BulkResponseItem val$it;
                    {
                        this.val$it = bulkResponseItem;
                    }

                    @Override
                    public int status() {
                        return this.val$it.status();
                    }

                    @Override
                    public SinkErrorCause error() {
                        return this.val$it.error() == null ? null : new SinkErrorCause(){

                            @Override
                            public @Nullable String reason() {
                                return val$it.error().reason();
                            }

                            public String toString() {
                                StringWriter w = new StringWriter();
                                JsonGenerator generator = jsonpMapper.jsonProvider().createGenerator((Writer)w);
                                val$it.error().serialize(generator, jsonpMapper);
                                generator.close();
                                return w.toString();
                            }
                        };
                    }
                });
            }
        };
    }

    @Override
    public void close() throws IOException {
        ((OpenSearchTransport)this.client._transport()).close();
    }

    @Override
    public Optional<JsonNode> getDocument(String index, String id, @Nullable String routing) {
        try {
            GetResponse response = this.client.get(req -> {
                req.index(index).id(id);
                if (routing != null) {
                    req.routing(routing);
                }
                return req;
            }, JsonNode.class);
            if (!response.found()) {
                return Optional.empty();
            }
            JsonNode doc = Objects.requireNonNull((JsonNode)response.source());
            String responseRouting = response.routing();
            if (responseRouting != null) {
                ((ObjectNode)doc).set("_routing", (JsonNode)new TextNode(responseRouting));
            }
            return Optional.of(doc);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long countDocuments(String index) {
        try {
            CountResponse response = this.client.count(req -> req.index(index, new String[0]));
            return response.count();
        }
        catch (ResponseException e) {
            return -1L;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<SinkTestOps.MultiGetItem> multiGet(String index, Collection<String> ids) {
        ArrayList<SinkTestOps.MultiGetItem> result = new ArrayList<SinkTestOps.MultiGetItem>();
        try {
            MgetResponse response = this.client.mget(builder -> builder.index(index).ids(List.copyOf(Set.copyOf(ids))), JsonNode.class);
            for (MultiGetResponseItem item : response.docs()) {
                if (item.isFailure()) {
                    result.add(new SinkTestOps.MultiGetItem(item.failure().id(), item.failure().error().reason(), null));
                    continue;
                }
                result.add(new SinkTestOps.MultiGetItem(item.result().id(), null, (JsonNode)item.result().source()));
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

