/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.cli;

import com.couchbase.connector.VersionHelper;
import com.couchbase.connector.util.EnvironmentHelper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public abstract class AbstractCliCommand {
    static File defaultConfigFile() {
        return new File(EnvironmentHelper.getInstallDir(), "config/default-connector.toml");
    }

    static {
        String appHome = System.getenv("APP_HOME");
        if (appHome == null) {
            System.err.println("WARNING: Environment variable 'APP_HOME' not set (launch script is responsible for this). Using embedded logging config.");
        } else {
            System.setProperty("log4j.configurationFile", appHome + "/config/log4j2.xml");
        }
    }

    public static class CommonParser {
        protected final OptionParser parser = new OptionParser();
        public final OptionSpec<File> configFile = this.parser.accepts("config", "Optionally specify a config file other than the default. See the 'config' directory for examples.").withRequiredArg().ofType(File.class).describedAs("path to config file").defaultsTo((Object)AbstractCliCommand.defaultConfigFile(), (Object[])new File[0]);

        public OptionSet parse(String ... args) throws IOException {
            try {
                this.parser.accepts("version", "Display connector version information.");
                this.handleVersionAndHelp(this.parser, args);
                OptionSet options = this.parser.parse(args);
                File configFile = (File)this.configFile.value(options);
                if (!configFile.exists()) {
                    System.err.println("ERROR: Config file not found at " + String.valueOf(configFile.getAbsoluteFile()));
                    System.err.println("       Please create this file, or use the --config option to specify a different file.");
                    System.err.println("       Examples may be found in the 'config' directory.");
                    System.exit(1);
                }
                return options;
            }
            catch (OptionException e) {
                System.err.println(e.getMessage());
                System.err.println();
                this.parser.printHelpOn((OutputStream)System.err);
                System.exit(1);
                throw new AssertionError((Object)"unreachable");
            }
        }

        void handleVersionAndHelp(OptionParser parser, String[] args) throws IOException {
            OptionParser versionParser = new OptionParser();
            versionParser.allowsUnrecognizedOptions();
            versionParser.accepts("version");
            versionParser.accepts("help");
            if (versionParser.parse(args).has("version")) {
                System.out.println(VersionHelper.getVersionString());
                System.exit(0);
            }
            if (versionParser.parse(args).has("help")) {
                parser.printHelpOn((OutputStream)System.out);
                System.exit(0);
            }
        }
    }
}

