/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.cli;

import com.couchbase.client.java.Bucket;
import com.couchbase.connector.config.es.ConnectorConfig;
import com.couchbase.connector.config.es.ImmutableConnectorConfig;
import com.couchbase.connector.dcp.Checkpoint;
import com.couchbase.connector.dcp.CouchbaseCheckpointDao;
import com.couchbase.connector.dcp.CouchbaseHelper;
import com.couchbase.connector.dcp.ResolvedBucketConfig;
import com.couchbase.connector.elasticsearch.cli.AbstractCliCommand;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointBackup
extends AbstractCliCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckpointBackup.class);

    public static void main(String[] args) throws Exception {
        OptionsParser parser = new OptionsParser();
        OptionSet options = parser.parse(args);
        File configFile = (File)options.valueOf(parser.configFile);
        File outputFile = (File)options.valueOf(parser.outputFile);
        System.out.println("Reading connector configuration from " + String.valueOf(configFile.getAbsoluteFile()));
        ImmutableConnectorConfig config = ConnectorConfig.from(configFile);
        CheckpointBackup.backup(config, outputFile);
    }

    public static void backup(ConnectorConfig config, File outputFile) throws IOException {
        Bucket bucket = CouchbaseHelper.openMetadataBucket(config);
        ResolvedBucketConfig bucketConfig = CouchbaseHelper.getBucketConfig(config.couchbase(), bucket);
        String bucketUuid = "";
        CouchbaseCheckpointDao checkpointDao = new CouchbaseCheckpointDao(CouchbaseHelper.getMetadataCollection(bucket, config.couchbase()), config.group().name());
        int numVbuckets = bucketConfig.numberOfPartitions();
        Set<Integer> vbuckets = IntStream.range(0, numVbuckets).boxed().collect(Collectors.toSet());
        Map<Integer, Checkpoint> checkpoints = checkpointDao.loadOrDefaultToZero("", vbuckets);
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        output.put("formatVersion", 1);
        output.put("bucketUuid", bucketConfig.uuid());
        output.put("vbuckets", checkpoints);
        CheckpointBackup.atomicWrite(outputFile, tempFile -> {
            try (FileOutputStream out = new FileOutputStream(tempFile);){
                new ObjectMapper().writeValue((OutputStream)out, (Object)output);
            }
        });
        System.out.println("Wrote checkpoint for connector '" + config.group().name() + "' to file " + outputFile.getAbsolutePath());
    }

    public static void atomicWrite(File destFile, FileConsumer tempFileWriter) throws IOException {
        File outputDir = destFile.getAbsoluteFile().getParentFile();
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new IOException("Failed to create output directory: " + String.valueOf(outputDir));
        }
        File temp = File.createTempFile(destFile.getName(), null, outputDir);
        try {
            tempFileWriter.accept(temp);
            Files.move(temp.toPath(), destFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (Exception t) {
            if (temp.exists() && !temp.delete()) {
                LOGGER.warn("Failed to delete temp file: {}", (Object)temp);
            }
            throw t;
        }
    }

    @FunctionalInterface
    public static interface FileConsumer {
        public void accept(File var1) throws IOException;
    }

    private static class OptionsParser
    extends AbstractCliCommand.CommonParser {
        final OptionSpec<File> outputFile;

        private OptionsParser() {
            this.outputFile = this.parser.accepts("output", "Checkpoint file to create. Pro tip: On Unix-like systems, include a timestamp like: checkpoint-$(date -u +%Y-%m-%dT%H:%M:%SZ).json").withRequiredArg().ofType(File.class).describedAs("checkpoint.json").required();
        }
    }
}

