/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.cli;

import com.couchbase.connector.cluster.consul.ConsulContext;
import com.couchbase.connector.config.es.ConnectorConfig;
import com.couchbase.connector.elasticsearch.cli.CheckpointBackup;
import com.couchbase.connector.elasticsearch.cli.ConsulCli;
import com.couchbase.connector.elasticsearch.cli.ConsulCommand;
import java.io.File;
import java.io.IOException;
import picocli.CommandLine;

@CommandLine.Command(name="checkpoint-backup", description={"Saves the replication checkpoint to a file on the local filesystem."})
class CheckpointBackupCommand
extends ConsulCommand
implements Runnable {
    @CommandLine.Option(names={"-g", "--group"}, required=true, description={"The name of the connector group to operate on."})
    private String group;
    @CommandLine.Option(names={"-o", "--output"}, paramLabel="<checkpoint.json>", required=true, description={"Checkpoint file to create. Tip: On Unix-like systems, include a timestamp like: %n    checkpoint-$(date -u +%%Y-%%m-%%dT%%H:%%M:%%SZ).json "})
    private File output;

    CheckpointBackupCommand() {
    }

    @Override
    public void run() {
        try (ConsulContext ctx = new ConsulContext(this.consulAddress(), this.consulConfig(), this.group, null);){
            ConsulCli.validateGroup(ctx);
            ConnectorConfig config = ctx.readConfigOrExit(ConnectorConfig::from);
            CheckpointBackup.backup(config, this.output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

