/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.cli;

import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.dcp.Client;
import com.couchbase.client.dcp.state.PartitionState;
import com.couchbase.client.dcp.state.SessionState;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.Collection;
import com.couchbase.connector.config.es.ConnectorConfig;
import com.couchbase.connector.config.es.ImmutableConnectorConfig;
import com.couchbase.connector.dcp.Checkpoint;
import com.couchbase.connector.dcp.CheckpointDao;
import com.couchbase.connector.dcp.CouchbaseCheckpointDao;
import com.couchbase.connector.dcp.CouchbaseHelper;
import com.couchbase.connector.dcp.DcpHelper;
import com.couchbase.connector.dcp.ResolvedBucketConfig;
import com.couchbase.connector.dcp.SnapshotMarker;
import com.couchbase.connector.elasticsearch.cli.AbstractCliCommand;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointClear
extends AbstractCliCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckpointClear.class);

    public static void main(String[] args) throws Exception {
        OptionsParser parser = new OptionsParser();
        OptionSet options = parser.parse(args);
        File configFile = (File)options.valueOf(parser.configFile);
        System.out.println("Reading connector configuration from " + String.valueOf(configFile.getAbsoluteFile()));
        ImmutableConnectorConfig config = ConnectorConfig.from(configFile);
        CheckpointClear.run(config, options.has(parser.catchUp));
    }

    public static void clear(ConnectorConfig config) throws IOException {
        CheckpointClear.run(config, false);
    }

    public static void catchUp(ConnectorConfig config) throws IOException {
        CheckpointClear.run(config, true);
    }

    private static void run(ConnectorConfig config, boolean catchUp) throws IOException {
        try (Cluster cluster = CouchbaseHelper.createCluster(config);){
            Bucket metadataBucket = CouchbaseHelper.waitForBucket(cluster, config.couchbase().metadataBucket());
            Collection metadataCollection = CouchbaseHelper.getMetadataCollection(metadataBucket, config.couchbase());
            ResolvedBucketConfig bucketConfig = CouchbaseHelper.getBucketConfig(config.couchbase(), metadataBucket);
            Set<SeedNode> kvNodes = CouchbaseHelper.getKvNodes(config.couchbase(), metadataBucket);
            CouchbaseCheckpointDao checkpointDao = new CouchbaseCheckpointDao(metadataCollection, config.group().name());
            if (catchUp) {
                CheckpointClear.setCheckpointToNow(config, kvNodes, checkpointDao);
                System.out.println("Set checkpoint for connector '" + config.group().name() + "' to match current state of Couchbase bucket.");
            } else {
                int numVbuckets = bucketConfig.numberOfPartitions();
                Set<Integer> vbuckets = IntStream.range(0, numVbuckets).boxed().collect(Collectors.toSet());
                checkpointDao.clear(bucketConfig.uuid(), vbuckets);
                System.out.println("Cleared checkpoint for connector '" + config.group().name() + "'.");
            }
        }
    }

    private static void setCheckpointToNow(ConnectorConfig config, Set<SeedNode> kvNodes, CheckpointDao checkpointDao) throws IOException {
        Map<Integer, Checkpoint> now = CheckpointClear.getNowForAllPartitions(config, kvNodes);
        checkpointDao.save("", now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, Checkpoint> getNowForAllPartitions(ConnectorConfig config, Set<SeedNode> kvNodes) {
        Client dcpClient = DcpHelper.newClient(config.group().name(), config.couchbase(), kvNodes, config.trustStore().orElse(null));
        try {
            dcpClient.connect().block();
            int numPartitions = dcpClient.numPartitions();
            HashSet<Integer> allPartitions = new HashSet<Integer>(DcpHelper.allPartitions(numPartitions));
            DcpHelper.getCurrentSeqnos(dcpClient, allPartitions);
            SessionState sessionState = dcpClient.sessionState();
            HashMap<Integer, Checkpoint> now = new HashMap<Integer, Checkpoint>();
            for (int i = 0; i < allPartitions.size(); ++i) {
                PartitionState p = sessionState.get(i);
                long seqno = p.getStartSeqno();
                now.put(i, new Checkpoint(p.getLastUuid(), seqno, new SnapshotMarker(seqno, seqno)));
            }
            HashMap<Integer, Checkpoint> hashMap = now;
            return hashMap;
        }
        finally {
            dcpClient.disconnect().block();
        }
    }

    private static class OptionsParser
    extends AbstractCliCommand.CommonParser {
        final OptionSpec<Void> catchUp;

        private OptionsParser() {
            this.catchUp = this.parser.accepts("catch-up", "Set the checkpoint to the current state of the Couchbase bucket.");
        }
    }
}

