/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.cli;

import com.couchbase.connector.cluster.consul.ConsulContext;
import com.couchbase.connector.config.es.ConnectorConfig;
import com.couchbase.connector.elasticsearch.cli.CheckpointClear;
import com.couchbase.connector.elasticsearch.cli.ConsulCli;
import com.couchbase.connector.elasticsearch.cli.ConsulCommand;
import com.google.common.base.Throwables;
import picocli.CommandLine;

@CommandLine.Command(name="checkpoint-clear", description={"Clears the replication checkpoint for the specified group, causing the connector to replicate from the beginning."})
class CheckpointClearCommand
extends ConsulCommand
implements Runnable {
    @CommandLine.Option(names={"-g", "--group"}, required=true, description={"The name of the connector group to operate on."})
    private String group;

    CheckpointClearCommand() {
    }

    @Override
    public void run() {
        try (ConsulContext ctx = new ConsulContext(this.consulAddress(), this.consulConfig(), this.group, null);){
            ConsulCli.validateGroup(ctx);
            ConnectorConfig config = ctx.readConfigOrExit(ConnectorConfig::from);
            System.out.println("Pausing connector prior to clearing checkpoints...");
            boolean wasPausedAlready = ctx.pause();
            System.out.println("Clearing checkpoints...");
            CheckpointClear.clear(config);
            if (!wasPausedAlready) {
                System.out.println("Resuming connector...");
                ctx.resume();
            }
            System.out.println("Checkpoint cleared.");
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

