/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.cli;

import com.couchbase.client.java.Bucket;
import com.couchbase.connector.config.es.ConnectorConfig;
import com.couchbase.connector.config.es.ImmutableConnectorConfig;
import com.couchbase.connector.dcp.Checkpoint;
import com.couchbase.connector.dcp.CouchbaseCheckpointDao;
import com.couchbase.connector.dcp.CouchbaseHelper;
import com.couchbase.connector.dcp.ResolvedBucketConfig;
import com.couchbase.connector.elasticsearch.cli.AbstractCliCommand;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public class CheckpointRestore
extends AbstractCliCommand {
    public static void main(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        OptionSet options = parser.parse(args);
        File configFile = (File)options.valueOf(parser.configFile);
        System.out.println("Reading connector configuration from " + String.valueOf(configFile.getAbsoluteFile()));
        ImmutableConnectorConfig config = ConnectorConfig.from(configFile);
        File inputFile = (File)options.valueOf(parser.inputFile);
        CheckpointRestore.restore(config, inputFile);
    }

    public static void restore(ConnectorConfig config, File inputFile) throws IOException {
        Bucket bucket = CouchbaseHelper.openMetadataBucket(config);
        ResolvedBucketConfig bucketConfig = CouchbaseHelper.getBucketConfig(config.couchbase(), bucket);
        CouchbaseCheckpointDao checkpointDao = new CouchbaseCheckpointDao(CouchbaseHelper.getMetadataCollection(bucket, config.couchbase()), config.group().name());
        ObjectMapper mapper = new ObjectMapper();
        try (FileInputStream is = new FileInputStream(inputFile);){
            JsonNode json = mapper.readTree((InputStream)is);
            int formatVersion = json.path("formatVersion").intValue();
            String bucketUuid = json.path("bucketUuid").asText();
            if (formatVersion != 1) {
                throw new IllegalArgumentException("Unrecognized checkpoint format version: " + formatVersion);
            }
            if (!bucketUuid.equals(bucketConfig.uuid())) {
                throw new IllegalArgumentException("Bucket UUID mismatch; checkpoint is from a bucket with UUID " + bucketUuid + " but this bucket has UUID " + bucketConfig.uuid());
            }
            Map checkpoints = (Map)mapper.convertValue((Object)json.get("vbuckets"), (TypeReference)new TypeReference<Map<Integer, Checkpoint>>(){});
            if (checkpoints.size() != bucketConfig.numberOfPartitions()) {
                throw new IllegalArgumentException("Bucket has " + bucketConfig.numberOfPartitions() + " vbuckets but the checkpoint file has " + checkpoints.size() + " -- is it from a different operating system (for example, macOS vs Linux)?");
            }
            checkpointDao.save("", checkpoints);
        }
        System.out.println("Restored checkpoint for connector '" + config.group().name() + "' from file " + String.valueOf(inputFile));
    }

    private static class OptionParser
    extends AbstractCliCommand.CommonParser {
        final OptionSpec<File> inputFile;

        private OptionParser() {
            this.inputFile = this.parser.accepts("input", "Checkpoint file to restore").withRequiredArg().ofType(File.class).describedAs("checkpoint.json").required();
        }
    }
}

