/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.cli;

import com.couchbase.connector.cluster.consul.ConsulContext;
import com.couchbase.connector.config.es.ConnectorConfig;
import com.couchbase.connector.elasticsearch.cli.CheckpointRestore;
import com.couchbase.connector.elasticsearch.cli.ConsulCli;
import com.couchbase.connector.elasticsearch.cli.ConsulCommand;
import com.google.common.base.Throwables;
import java.io.File;
import picocli.CommandLine;

@CommandLine.Command(name="checkpoint-restore", description={"Sets the replication checkpoint from a backup file."})
class CheckpointRestoreCommand
extends ConsulCommand
implements Runnable {
    @CommandLine.Option(names={"-g", "--group"}, required=true, description={"The name of the connector group to operate on."})
    private String group;
    @CommandLine.Option(names={"-i", "--input"}, paramLabel="<checkpoint.json>", required=true, description={"Checkpoint file to restore."})
    private File input;

    CheckpointRestoreCommand() {
    }

    @Override
    public void run() {
        try (ConsulContext ctx = new ConsulContext(this.consulAddress(), this.consulConfig(), this.group, null);){
            ConsulCli.validateGroup(ctx);
            ConnectorConfig config = ctx.readConfigOrExit(ConnectorConfig::from);
            System.out.println("Pausing connector prior to restoring checkpoints...");
            boolean wasPausedAlready = ctx.pause();
            CheckpointRestore.restore(config, this.input);
            if (!wasPausedAlready) {
                System.out.println("Resuming connector...");
                ctx.resume();
            }
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

