/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.cli;

import com.couchbase.connector.cluster.consul.ConsulContext;
import com.couchbase.connector.cluster.consul.DocumentKeys;
import com.couchbase.connector.cluster.consul.ReactorHelper;
import com.couchbase.connector.config.es.ConnectorConfig;
import com.couchbase.connector.config.es.ImmutableConnectorConfig;
import com.couchbase.connector.elasticsearch.cli.ConsulCli;
import com.couchbase.connector.elasticsearch.cli.ConsulCommand;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import picocli.CommandLine;

@CommandLine.Command(name="configure", description={"Define a new connector group by uploading a configuration file. The name of the group is determined by the 'group' property in the config file."})
class ConfigureCommand
extends ConsulCommand
implements Runnable {
    @CommandLine.Option(names={"-i", "--input"}, paramLabel="<config.toml>", required=true, description={"Configuration file to upload."})
    private File input;

    ConfigureCommand() {
    }

    @Override
    public void run() {
        try {
            String configString = Files.asCharSource((File)this.input, (Charset)StandardCharsets.UTF_8).read();
            ImmutableConnectorConfig parsed = ConnectorConfig.from(configString);
            String group = parsed.group().name();
            System.out.println("Updating config for connector group '" + group + "'...");
            try (ConsulContext ctx = new ConsulContext(this.consulAddress(), this.consulConfig(), group, null);){
                ConsulCli.runWithNiceConnectionFailureMessage(ctx, () -> {
                    DocumentKeys keys = ctx.keys();
                    boolean success = ReactorHelper.blockSingle(ctx.client().kv().upsertKey(keys.config(), configString)).body();
                    if (!success) {
                        throw new RuntimeException("Failed to write config document to Consul.");
                    }
                });
            }
            System.out.println("Configuration updated for connector group '" + group + "'.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

