/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.cli;

import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.connector.VersionHelper;
import com.couchbase.connector.cluster.consul.ConsulContext;
import com.couchbase.connector.elasticsearch.cli.CheckpointBackupCommand;
import com.couchbase.connector.elasticsearch.cli.CheckpointCatchUpCommand;
import com.couchbase.connector.elasticsearch.cli.CheckpointClearCommand;
import com.couchbase.connector.elasticsearch.cli.CheckpointRestoreCommand;
import com.couchbase.connector.elasticsearch.cli.ConfigureCommand;
import com.couchbase.connector.elasticsearch.cli.GetConfigCommand;
import com.couchbase.connector.elasticsearch.cli.GroupsCommand;
import com.couchbase.connector.elasticsearch.cli.PauseCommand;
import com.couchbase.connector.elasticsearch.cli.ResumeCommand;
import com.couchbase.connector.elasticsearch.cli.RunCommand;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="cbes-consul", description={"Couchbase Elasticsearch Connector commands for coordinated mode with Consul"}, mixinStandardHelpOptions=true, versionProvider=ConsulCli.class, subcommands={RunCommand.class, ResumeCommand.class, ConfigureCommand.class, GetConfigCommand.class, PauseCommand.class, GroupsCommand.class, CheckpointClearCommand.class, CheckpointBackupCommand.class, CheckpointRestoreCommand.class, CheckpointCatchUpCommand.class})
public class ConsulCli
implements CommandLine.IVersionProvider {
    static void runWithNiceConnectionFailureMessage(ConsulContext ctx, Runnable r) {
        try {
            r.run();
        }
        catch (Throwable t) {
            if (CbThrowables.hasCause((Throwable)t, ConnectException.class) || CbThrowables.hasCause((Throwable)t, UnknownHostException.class)) {
                System.err.println("ERROR: Failed to connect to Consul at " + ctx.consulAddress() + " ; " + String.valueOf(t));
                System.exit(1);
            }
            throw t;
        }
    }

    public static void validateGroup(ConsulContext ctx) {
        ConsulCli.runWithNiceConnectionFailureMessage(ctx, () -> {
            List<String> configuredGroups = ctx.keys().configuredGroups();
            if (!configuredGroups.contains(ctx.serviceName())) {
                System.err.println("ERROR: There is no configured group called '" + ctx.serviceName() + "'.");
                System.err.println("Configure the group first using the 'configure' command, or target an existing configured group:");
                if (configuredGroups.isEmpty()) {
                    System.err.println("  (there are no existing groups)");
                } else {
                    configuredGroups.forEach(groupName -> System.err.println("  " + groupName));
                }
                System.exit(1);
            }
        });
    }

    public String[] getVersion() {
        return new String[]{"Couchbase Elasticsearch Connector " + VersionHelper.getVersionString(), "Java " + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version"), System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch")};
    }

    public static void main(String[] args) {
        CommandLine cmd = new CommandLine((Object)new ConsulCli());
        try {
            List list = (List)cmd.parseWithHandler((CommandLine.IParseResultHandler2)new CommandLine.RunLast(), args);
        }
        catch (CommandLine.ExecutionException e) {
            Object command = e.getCommandLine().getCommand();
            if (!(command instanceof Runnable) && !(command instanceof Callable)) {
                e.getCommandLine().usage(System.err);
                System.exit(1);
                return;
            }
            throw e;
        }
    }

    static {
        String appHome = System.getenv("APP_HOME");
        if (appHome == null) {
            System.err.println("WARNING: Environment variable 'APP_HOME' not set (launch script is responsible for this). Using embedded logging config.");
        } else {
            System.setProperty("log4j.configurationFile", appHome + "/config/log4j2.xml");
        }
    }
}

