/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.cli;

import com.couchbase.connector.config.ConfigException;
import com.couchbase.connector.config.common.ConsulConfig;
import com.couchbase.connector.config.common.ImmutableConsulConfig;
import com.google.common.net.HostAndPort;
import java.io.File;
import java.io.IOException;
import picocli.CommandLine;

abstract class ConsulCommand {
    @CommandLine.Option(names={"-a", "--consul-agent"}, paramLabel="host[:port]", description={"The hostname and port of the Consul agent to connect to. Defaults to localhost:8500"})
    protected String consulAgentAddress = "localhost:8500";
    @CommandLine.Option(names={"-c", "--consul-config"}, paramLabel="<consul.toml>", description={"File with optional Consul configuration options."})
    protected File consulConfig;

    ConsulCommand() {
    }

    protected HostAndPort consulAddress() {
        return HostAndPort.fromString((String)this.consulAgentAddress);
    }

    protected ConsulConfig consulConfig() {
        if (this.consulConfig == null) {
            System.out.println("Consul config file not specified; using default Consul settings.");
            return ImmutableConsulConfig.builder().build();
        }
        try {
            return ConsulConfig.from(this.consulConfig);
        }
        catch (IOException e) {
            throw new ConfigException(e.getMessage());
        }
    }
}

