/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.cli;

import com.couchbase.connector.cluster.consul.ConsulContext;
import com.couchbase.connector.elasticsearch.cli.CheckpointBackup;
import com.couchbase.connector.elasticsearch.cli.ConsulCli;
import com.couchbase.connector.elasticsearch.cli.ConsulCommand;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import picocli.CommandLine;

@CommandLine.Command(name="get-config", description={"Retrieve the configuration for a connector group and save it to a file on the local filesystem."})
class GetConfigCommand
extends ConsulCommand
implements Runnable {
    @CommandLine.Option(names={"-o", "--output"}, paramLabel="<config.toml>", required=true, description={"File to create."})
    private File output;
    @CommandLine.Option(names={"-g", "--group"}, required=true, description={"The name of the connector group to operate on."})
    private String group;

    GetConfigCommand() {
    }

    @Override
    public void run() {
        try (ConsulContext ctx = new ConsulContext(this.consulAddress(), this.consulConfig(), this.group, null);){
            ConsulCli.validateGroup(ctx);
            String config = ctx.readConfig();
            CheckpointBackup.atomicWrite(this.output, file -> Files.write((byte[])config.getBytes(StandardCharsets.UTF_8), (File)file));
            System.out.println("Configuration for connector group '" + this.group + "' written to file " + this.output.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

