/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.cli;

import com.couchbase.connector.cluster.consul.ConsulContext;
import com.couchbase.connector.elasticsearch.cli.ConsulCli;
import com.couchbase.connector.elasticsearch.cli.ConsulCommand;
import com.google.common.base.Throwables;
import java.util.concurrent.TimeoutException;
import picocli.CommandLine;

@CommandLine.Command(name="pause", description={"Pauses the connector."})
class PauseCommand
extends ConsulCommand
implements Runnable {
    @CommandLine.Option(names={"-g", "--group"}, required=true, description={"The name of the connector group to operate on."})
    private String group;

    PauseCommand() {
    }

    @Override
    public void run() {
        try (ConsulContext ctx = new ConsulContext(this.consulAddress(), this.consulConfig(), this.group, null);){
            ConsulCli.validateGroup(ctx);
            System.out.println("Attempting to pause connector group: " + this.group);
            ctx.pause();
            System.out.println("Connector group '" + this.group + "' is now paused.");
        }
        catch (TimeoutException e) {
            System.err.println("ERROR: Pause failed; timed out waiting for cluster to quiesce.");
            System.exit(1);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

