/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.cli;

import com.couchbase.connector.cluster.consul.ConsulContext;
import com.couchbase.connector.elasticsearch.cli.ConsulCli;
import com.couchbase.connector.elasticsearch.cli.ConsulCommand;
import com.google.common.base.Throwables;
import picocli.CommandLine;

@CommandLine.Command(name="resume", description={"Resume the connector if it is paused."})
class ResumeCommand
extends ConsulCommand
implements Runnable {
    @CommandLine.Option(names={"-g", "--group"}, required=true, description={"The name of the connector group to operate on."})
    private String group;

    ResumeCommand() {
    }

    @Override
    public void run() {
        try (ConsulContext ctx = new ConsulContext(this.consulAddress(), this.consulConfig(), this.group, null);){
            ConsulCli.validateGroup(ctx);
            System.out.println("Attempting to resume connector group: " + this.group);
            ctx.resume();
            System.out.println("Connector group '" + this.group + "' is now resumed.");
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

