/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.cli;

import com.couchbase.connector.cluster.consul.ConsulConnector;
import com.couchbase.connector.cluster.consul.ConsulContext;
import com.couchbase.connector.elasticsearch.cli.ConsulCli;
import com.couchbase.connector.elasticsearch.cli.ConsulCommand;
import picocli.CommandLine;

@CommandLine.Command(name="run", description={"Run a connector worker process."})
class RunCommand
extends ConsulCommand
implements Runnable {
    @CommandLine.Option(names={"-g", "--group"}, required=true, description={"The name of the connector group to join."})
    private String group;
    @CommandLine.Option(names={"-i", "--service-id"}, description={"The Consul service ID to assign to the worker. Required if you want to run multiple workers in the same group using the same Consul agent."})
    private String serviceId;

    RunCommand() {
    }

    @Override
    public void run() {
        try (ConsulContext ctx = new ConsulContext(this.consulAddress(), this.consulConfig(), this.group, this.serviceId);){
            ConsulCli.validateGroup(ctx);
            ConsulConnector.run(ctx);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.exit(1);
    }
}

