/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.io;

import com.couchbase.connector.elasticsearch.io.BackoffPolicy;
import com.couchbase.connector.elasticsearch.io.MoreBackoffPolicies;
import com.google.common.collect.Iterables;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;

public class BackoffPolicyBuilder {
    private BackoffPolicy policy;

    public static BackoffPolicyBuilder truncatedExponentialBackoff(Duration seed, Duration cap) {
        return new BackoffPolicyBuilder(MoreBackoffPolicies.truncatedExponentialBackoff(seed, cap));
    }

    public static BackoffPolicyBuilder constantBackoff(final Duration delay) {
        BackoffPolicy policy = new BackoffPolicy(){

            public String toString() {
                return "constantBackoff(delay: " + String.valueOf(delay) + ")";
            }

            @Override
            public Iterator<Duration> iterator() {
                return Iterables.cycle((Object[])new Duration[]{delay}).iterator();
            }
        };
        return new BackoffPolicyBuilder(policy);
    }

    public BackoffPolicyBuilder(BackoffPolicy policy) {
        this.policy = Objects.requireNonNull(policy);
    }

    public BackoffPolicyBuilder fullJitter() {
        this.policy = MoreBackoffPolicies.withFullJitter(this.policy);
        return this;
    }

    public BackoffPolicyBuilder timeout(Duration timeout) {
        this.policy = MoreBackoffPolicies.withTimeout(timeout, this.policy);
        return this;
    }

    public BackoffPolicyBuilder limit(int maxRetries) {
        this.policy = MoreBackoffPolicies.limit(maxRetries, this.policy);
        return this;
    }

    public BackoffPolicy build() {
        return this.policy;
    }
}

