/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.io;

import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.dcp.highlevel.Mutation;
import com.couchbase.connector.config.es.DocStructureConfig;
import com.couchbase.connector.dcp.Event;
import com.couchbase.connector.elasticsearch.io.DocumentTransformer;
import com.couchbase.connector.elasticsearch.io.PreserializedJson;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDocumentTransformer
implements DocumentTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDocumentTransformer.class);
    private static final JsonMapper jsonMapper = (JsonMapper)JsonMapper.builder().build();
    private static final JsonFactory jsonFactory = jsonMapper.getFactory();
    private final boolean documentContentAtTopLevel;
    private final String metadataFieldName;
    private final boolean wrapCounters;
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};

    public DefaultDocumentTransformer(DocStructureConfig docStructureConfig) {
        this.documentContentAtTopLevel = docStructureConfig.documentContentAtTopLevel();
        this.metadataFieldName = docStructureConfig.metadataFieldName();
        this.wrapCounters = docStructureConfig.wrapCounters();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isSingleValidJsonObject(byte[] json) {
        try (JsonParser parser = jsonFactory.createParser(json);){
            block13: {
                JsonToken token;
                if (parser.nextToken() != JsonToken.START_OBJECT) {
                    boolean bl = false;
                    return bl;
                }
                int depth = 1;
                while ((token = parser.nextToken()) != null) {
                    if (token == JsonToken.START_OBJECT) {
                        ++depth;
                        continue;
                    }
                    if (token != JsonToken.END_OBJECT || --depth != 0 || parser.nextToken() == null) {
                        continue;
                    }
                    break block13;
                }
                return true;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public @Nullable Object getElasticsearchDocument(Event mutationEvent) {
        Mutation mutation;
        Map<String, Object> esDocument;
        if (!mutationEvent.isMutation()) {
            throw new IllegalArgumentException("expected a mutation event");
        }
        byte[] bytes = mutationEvent.getContent();
        if (this.documentContentAtTopLevel && this.metadataFieldName == null && DefaultDocumentTransformer.isSingleValidJsonObject(bytes)) {
            return new PreserializedJson(bytes);
        }
        Map<String, Object> couchbaseDocument = this.getDocumentAsMap(bytes);
        if (couchbaseDocument == null) {
            LOGGER.debug("Skipping document {} because it's not a JSON Object", (Object)mutationEvent);
            return null;
        }
        if (this.documentContentAtTopLevel) {
            esDocument = couchbaseDocument;
        } else {
            esDocument = new HashMap<String, Object>();
            esDocument.put("doc", couchbaseDocument);
        }
        if (this.metadataFieldName != null && esDocument.putIfAbsent(this.metadataFieldName, this.getMetadata(mutation = (Mutation)mutationEvent.getChange())) != null) {
            LOGGER.warn("Metadata field name conflict; document {} already has field named '{}'", (Object)RedactableArgument.redactUser((Object)mutationEvent), (Object)this.metadataFieldName);
        }
        try {
            return new PreserializedJson(jsonMapper.writeValueAsString(esDocument));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private @Nullable Map<String, Object> getDocumentAsMap(byte[] bytes) {
        try {
            return (Map)jsonMapper.readValue(bytes, MAP_TYPE_REFERENCE);
        }
        catch (IOException notJsonObject) {
            return this.wrapCounters ? DefaultDocumentTransformer.wrapIfCounter(bytes) : null;
        }
    }

    private static @Nullable Map<String, Object> wrapIfCounter(byte[] bytes) {
        Long counter = DefaultDocumentTransformer.getCounterValue(bytes);
        if (counter == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("value", counter);
        return result;
    }

    static @Nullable Long getCounterValue(byte[] bytes) {
        try {
            JsonParser parser = jsonFactory.createParser(bytes);
            if (parser.nextValue() != JsonToken.VALUE_NUMBER_INT) {
                return null;
            }
            long counter = DefaultDocumentTransformer.unsignedLongValueExact(parser.getBigIntegerValue());
            if (parser.nextValue() != null) {
                return null;
            }
            return counter;
        }
        catch (Exception notCounter) {
            return null;
        }
    }

    private Map<String, Object> getMetadata(Mutation mutation) {
        long rev = mutation.getRevision();
        long cas = mutation.getCas();
        int expiration = mutation.getExpiry();
        int flags = mutation.getFlagsAsInt();
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("rev", DefaultDocumentTransformer.formatRevision(rev, cas, expiration, flags));
        meta.put("flags", flags);
        meta.put("expiration", expiration);
        meta.put("id", mutation.getKey());
        meta.put("vbucket", mutation.getVbucket());
        meta.put("vbuuid", mutation.getOffset().getVbuuid());
        meta.put("seqno", mutation.getOffset().getSeqno());
        meta.put("revSeqno", rev);
        meta.put("cas", cas);
        meta.put("lockTime", mutation.getLockTime());
        return meta;
    }

    private static String formatRevision(long rev, long cas, int expiration, int flags) {
        String revString = Long.toUnsignedString(rev);
        StringBuilder result = new StringBuilder(33 + revString.length()).append(revString).append("-");
        DefaultDocumentTransformer.appendPaddedHexLong(result, cas);
        DefaultDocumentTransformer.appendPaddedHexInt(result, expiration);
        DefaultDocumentTransformer.appendPaddedHexInt(result, flags);
        return result.toString();
    }

    private static void appendPaddedHexLong(StringBuilder sb, long value) {
        String hex = Long.toHexString(value);
        int pad = 16 - hex.length();
        DefaultDocumentTransformer.appendZeroes(sb, pad).append(hex);
    }

    private static void appendPaddedHexInt(StringBuilder sb, int value) {
        String hex = Integer.toHexString(value);
        int pad = 8 - hex.length();
        DefaultDocumentTransformer.appendZeroes(sb, pad).append(hex);
    }

    private static StringBuilder appendZeroes(StringBuilder sb, int count) {
        for (int i = 0; i < count; ++i) {
            sb.append('0');
        }
        return sb;
    }

    private static long unsignedLongValueExact(BigInteger i) {
        try {
            return Long.parseUnsignedLong(i.toString());
        }
        catch (NumberFormatException e) {
            throw new ArithmeticException("BigInteger out of unsigned long range");
        }
    }
}

