/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.io;

import com.couchbase.connector.config.es.TypeConfig;
import com.couchbase.connector.elasticsearch.io.RequestFactory;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RequestFactory.MatchResult", generator="Immutables")
@Immutable
public final class ImmutableMatchResult
implements RequestFactory.MatchResult {
    private final TypeConfig typeConfig;
    private final String index;

    private ImmutableMatchResult(TypeConfig typeConfig, String index) {
        this.typeConfig = typeConfig;
        this.index = index;
    }

    @Override
    public TypeConfig typeConfig() {
        return this.typeConfig;
    }

    @Override
    public String index() {
        return this.index;
    }

    public final ImmutableMatchResult withTypeConfig(TypeConfig value) {
        if (this.typeConfig == value) {
            return this;
        }
        TypeConfig newValue = Objects.requireNonNull(value, "typeConfig");
        return new ImmutableMatchResult(newValue, this.index);
    }

    public final ImmutableMatchResult withIndex(String value) {
        String newValue = Objects.requireNonNull(value, "index");
        if (this.index.equals(newValue)) {
            return this;
        }
        return new ImmutableMatchResult(this.typeConfig, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMatchResult && this.equalTo(0, (ImmutableMatchResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableMatchResult another) {
        return this.typeConfig.equals(another.typeConfig) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.typeConfig.hashCode();
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MatchResult").omitNullValues().add("typeConfig", (Object)this.typeConfig).add("index", (Object)this.index).toString();
    }

    public static ImmutableMatchResult copyOf(RequestFactory.MatchResult instance) {
        if (instance instanceof ImmutableMatchResult) {
            return (ImmutableMatchResult)instance;
        }
        return ImmutableMatchResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RequestFactory.MatchResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE_CONFIG = 1L;
        private static final long INIT_BIT_INDEX = 2L;
        private long initBits = 3L;
        @Nullable
        private TypeConfig typeConfig;
        @Nullable
        private String index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RequestFactory.MatchResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.typeConfig(instance.typeConfig());
            this.index(instance.index());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder typeConfig(TypeConfig typeConfig) {
            this.typeConfig = Objects.requireNonNull(typeConfig, "typeConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder index(String index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMatchResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMatchResult(this.typeConfig, this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("typeConfig");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build MatchResult, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

