/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.io;

import com.couchbase.client.core.util.NanoTimestamp;
import com.couchbase.connector.elasticsearch.io.BackoffPolicy;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

public class MoreBackoffPolicies {
    private MoreBackoffPolicies() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static BackoffPolicy truncatedExponentialBackoff(final Duration seedDelay, final Duration delayCap) {
        Objects.requireNonNull(seedDelay);
        Objects.requireNonNull(delayCap);
        Preconditions.checkArgument((seedDelay.toMillis() > 0L ? 1 : 0) != 0, (Object)"seed delay must be positive");
        return new BackoffPolicy(){

            public String toString() {
                return "truncatedExponentialBackoff(seed: " + String.valueOf(seedDelay) + ", cap: " + String.valueOf(delayCap) + ")";
            }

            @Override
            public Iterator<Duration> iterator() {
                return new Iterator<Duration>(){
                    long delay;
                    {
                        this.delay = seedDelay.toMillis();
                    }

                    @Override
                    public boolean hasNext() {
                        return true;
                    }

                    @Override
                    public Duration next() {
                        long shifted = this.delay << 1;
                        if (shifted <= 0L) {
                            return delayCap;
                        }
                        this.delay = shifted;
                        return Duration.ofMillis(Math.min(this.delay, delayCap.toMillis()));
                    }
                };
            }
        };
    }

    public static BackoffPolicy withFullJitter(final BackoffPolicy deterministic) {
        Objects.requireNonNull(deterministic);
        return new BackoffPolicy(){

            public String toString() {
                return String.valueOf(deterministic) + " + fullJitter";
            }

            @Override
            public Iterator<Duration> iterator() {
                return Iterators.transform(deterministic.iterator(), delay -> Duration.ofMillis(ThreadLocalRandom.current().nextLong(delay.toMillis() + 1L)));
            }
        };
    }

    public static BackoffPolicy withTimeout(final Duration timeout, final BackoffPolicy wrapped) {
        Objects.requireNonNull(wrapped);
        return new BackoffPolicy(){

            public String toString() {
                return String.valueOf(wrapped) + " + timeout(" + String.valueOf(timeout) + ")";
            }

            @Override
            public Iterator<Duration> iterator() {
                final NanoTimestamp start = NanoTimestamp.now();
                final Iterator wrappedIterator = wrapped.iterator();
                return new Iterator<Duration>(){

                    @Override
                    public boolean hasNext() {
                        return wrappedIterator.hasNext() && !start.hasElapsed(timeout);
                    }

                    @Override
                    public Duration next() {
                        return (Duration)wrappedIterator.next();
                    }
                };
            }
        };
    }

    public static BackoffPolicy limit(final int maxRetries, final BackoffPolicy wrapped) {
        Preconditions.checkArgument((maxRetries >= 0 ? 1 : 0) != 0, (Object)"maxRetries must be non-negative");
        return new BackoffPolicy(){

            public String toString() {
                return String.valueOf(wrapped) + " + limit(" + maxRetries + ")";
            }

            @Override
            public Iterator<Duration> iterator() {
                return Iterators.limit(wrapped.iterator(), (int)maxRetries);
            }
        };
    }
}

