/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.io;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

@JsonSerialize(using=Serializer.class)
public class PreserializedJson {
    private final String value;

    public PreserializedJson(String value) {
        this.value = Objects.requireNonNull(value);
    }

    public PreserializedJson(byte[] value) {
        this(new String(value, StandardCharsets.UTF_8));
    }

    public static class Serializer
    extends StdSerializer<PreserializedJson> {
        public Serializer() {
            super(PreserializedJson.class);
        }

        public void serialize(PreserializedJson value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeRaw(value.value);
        }
    }
}

