/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.io;

import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.connector.config.es.DocStructureConfig;
import com.couchbase.connector.config.es.RejectLogConfig;
import com.couchbase.connector.config.es.TypeConfig;
import com.couchbase.connector.dcp.DcpHelper;
import com.couchbase.connector.dcp.Event;
import com.couchbase.connector.elasticsearch.DocumentLifecycle;
import com.couchbase.connector.elasticsearch.Metrics;
import com.couchbase.connector.elasticsearch.io.DefaultDocumentTransformer;
import com.couchbase.connector.elasticsearch.io.DocumentTransformer;
import com.couchbase.connector.elasticsearch.io.ImmutableMatchResult;
import com.couchbase.connector.elasticsearch.sink.DeleteOperation;
import com.couchbase.connector.elasticsearch.sink.IndexOperation;
import com.couchbase.connector.elasticsearch.sink.Operation;
import com.couchbase.connector.elasticsearch.sink.RejectOperation;
import com.couchbase.connector.elasticsearch.sink.SinkBulkResponseItem;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.filter.FilteringParserDelegate;
import com.fasterxml.jackson.core.filter.JsonPointerBasedFilter;
import com.fasterxml.jackson.core.filter.TokenFilter;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Value;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestFactory.class);
    private static final Timer newIndexRequestTimer = Metrics.timer("new.index.req", "Time spent preparing an Elasticsearch indexing request.");
    private static final JsonFactory factory = new JsonFactory();
    private final DocumentTransformer documentTransformer;
    private final List<TypeConfig> types;
    private final RejectLogConfig rejectLogConfig;

    public RequestFactory(List<TypeConfig> types, DocStructureConfig docStructureConfig, RejectLogConfig rejectLogConfig) {
        this.types = Objects.requireNonNull(types);
        this.documentTransformer = new DefaultDocumentTransformer(docStructureConfig);
        this.rejectLogConfig = rejectLogConfig;
    }

    public @Nullable RejectOperation newRejectionLogRequest(Operation origRequest, SinkBulkResponseItem f) {
        if (this.rejectLogConfig.index() == null) {
            origRequest.getEvent().release();
            return null;
        }
        return new RejectOperation(this.rejectLogConfig.index(), origRequest, f);
    }

    public @Nullable RejectOperation newRejectionLogRequest(Event origEvent, MatchResult matchResult, Throwable failure) {
        if (this.rejectLogConfig.index() == null) {
            return null;
        }
        Operation.Type opType = origEvent.isMutation() ? Operation.Type.INDEX : Operation.Type.DELETE;
        return new RejectOperation(this.rejectLogConfig.index(), origEvent, matchResult.index(), opType, failure.getMessage());
    }

    public @Nullable Operation newDocWriteRequest(Event e) {
        if (DcpHelper.isMetadata(e)) {
            return null;
        }
        MatchResult matchResult = this.match(e);
        if (matchResult == null) {
            DocumentLifecycle.logSkippedBecauseMatchedNoRules(e);
            return null;
        }
        if (matchResult.typeConfig().ignore()) {
            DocumentLifecycle.logSkippedBecauseMatchedIgnoredType(e, matchResult.typeConfig());
            return null;
        }
        DocumentLifecycle.logMatchedTypeRule(e, matchResult.index(), matchResult.typeConfig());
        if (e.isMutation()) {
            return this.newIndexRequest(e, matchResult);
        }
        if (matchResult.typeConfig().ignoreDeletes()) {
            DocumentLifecycle.logSkippedBecauseRuleSaysIgnoreDeletes(e);
            return null;
        }
        return this.newDeleteRequest(e, matchResult);
    }

    private DeleteOperation newDeleteRequest(Event event, MatchResult matchResult) {
        return new DeleteOperation(matchResult.index(), event);
    }

    private @Nullable IndexOperation newIndexRequest(Event event, MatchResult matchResult) {
        try {
            Timer.Sample timerContext = Timer.start();
            Object document = this.documentTransformer.getElasticsearchDocument(event);
            if (document == null) {
                return null;
            }
            IndexOperation op = new IndexOperation(matchResult.index(), event, document, matchResult.typeConfig().pipeline(), this.getRouting(event, matchResult.typeConfig().routing()));
            timerContext.stop(newIndexRequestTimer);
            return op;
        }
        catch (Exception failure) {
            LOGGER.warn("Failed to create doc write request for {} ; adding an entry to the rejection log instead.", (Object)RedactableArgument.redactUser((Object)event), (Object)failure);
            Metrics.rejectionCounter().increment();
            return this.newRejectionLogRequest(event, matchResult, failure);
        }
    }

    private String getRouting(Event event, JsonPointer routingPointer) throws IOException {
        Objects.requireNonNull(event);
        if (routingPointer == null) {
            return null;
        }
        FilteringParserDelegate parser = new FilteringParserDelegate(factory.createParser(event.getContent()), (TokenFilter)new JsonPointerBasedFilter(routingPointer), TokenFilter.Inclusion.ONLY_INCLUDE_ALL, false);
        if (parser.nextToken() == null) {
            LOGGER.warn("Document '{}' has no field matching routing JSON pointer '{}'", (Object)RedactableArgument.redactUser((Object)event.getKey()), (Object)routingPointer);
            return null;
        }
        String routingValue = parser.getValueAsString();
        if (routingValue == null) {
            LOGGER.warn("Document '{}' has a null or non-scalar value for routing JSON pointer '{}'", (Object)RedactableArgument.redactUser((Object)event.getKey()), (Object)routingPointer);
            return null;
        }
        LOGGER.trace("Routing value for {} is {}", (Object)event.getKey(), (Object)routingValue);
        return routingValue;
    }

    private @Nullable MatchResult match(Event event) {
        for (TypeConfig type : this.types) {
            String index = type.matcher().getIndexIfMatches(event);
            if (index == null) continue;
            return ImmutableMatchResult.builder().typeConfig(type).index(index).build();
        }
        return null;
    }

    @Value.Immutable
    public static interface MatchResult {
        public TypeConfig typeConfig();

        public String index();
    }
}

