/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.sink;

import com.couchbase.connector.dcp.Event;
import com.couchbase.connector.elasticsearch.sink.BaseOperation;
import com.couchbase.connector.elasticsearch.sink.Operation;
import com.couchbase.connector.elasticsearch.sink.SinkBulkRequestBuilder;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class IndexOperation
extends BaseOperation {
    private final @Nullable String pipeline;
    private final @Nullable String routing;
    private final Object document;

    public IndexOperation(String index, Event event, Object document, @Nullable String pipeline, @Nullable String routing) {
        super(index, event);
        this.pipeline = pipeline;
        this.routing = routing;
        this.document = Objects.requireNonNull(document);
    }

    @Override
    public int estimatedSizeInBytes() {
        return 50 + this.getEvent().getContent().length;
    }

    @Override
    public void addTo(SinkBulkRequestBuilder bulkRequestBuilder) {
        bulkRequestBuilder.add(this);
    }

    @Override
    public Operation.Type type() {
        return Operation.Type.INDEX;
    }

    public @Nullable String pipeline() {
        return this.pipeline;
    }

    public @Nullable String routing() {
        return this.routing;
    }

    public Object document() {
        return this.document;
    }
}

