/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.sink;

import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.connector.dcp.Event;
import com.couchbase.connector.elasticsearch.sink.SinkBulkResponseItem;
import com.couchbase.connector.elasticsearch.sink.SinkErrorCause;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;

class RetryReporter {
    private final ListMultimap<String, String> errorMessageToEvents = ArrayListMultimap.create();
    private final Logger logger;

    private RetryReporter(Logger logger) {
        this.logger = Objects.requireNonNull(logger);
    }

    static RetryReporter forLogger(Logger logger) {
        return new RetryReporter(logger);
    }

    void add(Event e, SinkBulkResponseItem failure) {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        SinkErrorCause cause = failure.error();
        if (cause == null) {
            throw new IllegalArgumentException("bulk response item did not fail");
        }
        String message = "status=" + failure.status() + " message=" + cause.reason();
        this.errorMessageToEvents.put((Object)message, (Object)RedactableArgument.redactUser((Object)e).toString());
    }

    void report() {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        for (String errorMessage : this.errorMessageToEvents.keySet()) {
            List events = this.errorMessageToEvents.get((Object)errorMessage);
            String message = "Retrying " + (String)events.get(0);
            if (events.size() > 1) {
                message = message + " (and " + (events.size() - 1) + " others)";
            }
            message = message + " due to: " + errorMessage;
            this.logger.info(message);
        }
    }
}

