/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.sink;

import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.connector.config.es.ConnectorConfig;
import com.couchbase.connector.elasticsearch.ElasticsearchHelper;
import com.couchbase.connector.elasticsearch.ElasticsearchSinkOps;
import com.couchbase.connector.elasticsearch.ElasticsearchVersionSniffer;
import com.couchbase.connector.elasticsearch.OpenSearchHelper;
import com.couchbase.connector.elasticsearch.OpenSearchSinkOps;
import com.couchbase.connector.elasticsearch.sink.Operation;
import com.couchbase.connector.elasticsearch.sink.SinkBulkResponse;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.io.CloseMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SinkOps
extends Closeable {
    public ObjectNode info();

    public SinkBulkResponse bulk(List<Operation> var1) throws IOException;

    public static SinkOps create(ConnectorConfig config) {
        SinkOps sinkOps;
        Logger log = LoggerFactory.getLogger(SinkOps.class);
        if (!config.elasticsearch().aws().region().isEmpty()) {
            log.info("Connector config specifies an AWS region; activating Amazon OpenSearch Service mode.");
            OpenSearchSinkOps sinkOps2 = OpenSearchHelper.newAwsOpenSearchSinkOps(config);
            log.info("Verifying connectivity to Amazon OpenSearch Service domain...");
            ObjectNode info = sinkOps2.info();
            log.info("Successfully connected to Amazon OpenSearch Service domain. Sink info: {}", (Object)RedactableArgument.redactSystem((Object)info));
            return sinkOps2;
        }
        if (config.elasticsearch().elasticCloud().enabled()) {
            log.info("Connector config specifies Elastic Cloud mode is enabled.");
            ElasticsearchSinkOps sinkOps3 = ElasticsearchHelper.newElasticsearchSinkOps(config);
            log.info("Verifying connectivity to Elastic Cloud Elasticsearch endpoint...");
            ObjectNode info = sinkOps3.info();
            log.info("Successfully connected to Elastic Cloud Elasticsearch endpoint. Sink info: {}", (Object)RedactableArgument.redactSystem((Object)info));
            return sinkOps3;
        }
        CloseableHttpAsyncClient httpClient = OpenSearchHelper.newHttpClient(config);
        ElasticsearchVersionSniffer.FlavorAndVersion fav = new ElasticsearchVersionSniffer(httpClient).sniff(OpenSearchHelper.hosts(config.elasticsearch()), Duration.ofMinutes(2L));
        if (fav.flavor != ElasticsearchVersionSniffer.Flavor.OPENSEARCH) {
            httpClient.close(CloseMode.IMMEDIATE);
        }
        switch (fav.flavor) {
            case OPENSEARCH: {
                sinkOps = OpenSearchHelper.newOpenSearchSinkOps(httpClient, config);
                break;
            }
            case ELASTICSEARCH: {
                sinkOps = ElasticsearchHelper.newElasticsearchSinkOps(config);
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized sink: " + String.valueOf(fav));
            }
        }
        log.info("Verifying connectivity to {}...", (Object)fav.flavor);
        ObjectNode info = sinkOps.info();
        log.info("Successfully connected to {}. Sink info: {}", (Object)fav.flavor, (Object)RedactableArgument.redactSystem((Object)info));
        return sinkOps;
    }
}

