/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.sink;

import com.couchbase.connector.dcp.Event;
import com.couchbase.connector.elasticsearch.ErrorListener;
import com.couchbase.connector.elasticsearch.sink.SinkWriter;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkWorker
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SinkWorker.class);
    private static final AtomicInteger nameCounter = new AtomicInteger();
    private final Thread thread;
    private final ErrorListener errorHandler;
    private final SinkWriter writer;
    private final BlockingQueue<Event> eventQueue = new LinkedBlockingQueue<Event>();
    private final BlockingQueue<Throwable> fatalErrorQueue;

    private SinkWorker(SinkWriter writer, BlockingQueue<Throwable> fatalErrorQueue, @Nullable ErrorListener errorListener) {
        this.writer = Objects.requireNonNull(writer);
        this.errorHandler = errorListener == null ? ErrorListener.NOOP : errorListener;
        this.fatalErrorQueue = Objects.requireNonNull(fatalErrorQueue);
        this.thread = new Thread(this.doRun(), "es-worker-" + nameCounter.getAndIncrement());
        this.thread.setDaemon(true);
    }

    public static SinkWorker newWorker(SinkWriter writer, BlockingQueue<Throwable> fatalErrorQueue, @Nullable ErrorListener errorListener) {
        SinkWorker worker = new SinkWorker(writer, fatalErrorQueue, errorListener);
        worker.thread.start();
        return worker;
    }

    public void submit(Event event) {
        this.eventQueue.add(event);
    }

    public int getQueueSize() {
        return this.eventQueue.size();
    }

    public long getCurrentRequestNanos() {
        return this.writer.getCurrentRequestNanos();
    }

    private Runnable doRun() {
        return () -> {
            try {
                while (!Thread.interrupted()) {
                    Event event = this.eventQueue.take();
                    this.writer.write(event);
                    while ((event = (Event)this.eventQueue.poll()) != null) {
                        this.writer.write(event);
                    }
                    this.writer.flush();
                }
            }
            catch (Throwable t) {
                if (!this.isNormalTermination(t)) {
                    LOGGER.warn("Error in Elasticsearch worker thread", t);
                }
                this.fatalErrorQueue.offer(t);
            }
            finally {
                SinkWorker.drainAndRelease(this.eventQueue);
                this.writer.close();
                LOGGER.info("{} stopped.", (Object)Thread.currentThread());
            }
        };
    }

    private static void drainAndRelease(BlockingQueue<Event> drainMe) {
        ArrayList releaseMe = new ArrayList(drainMe.size());
        drainMe.drainTo(releaseMe);
        releaseMe.forEach(Event::release);
    }

    private boolean isNormalTermination(Throwable t) {
        return t instanceof InterruptedException;
    }

    @Override
    public void close() {
        this.thread.interrupt();
    }

    public boolean join(long millis) throws InterruptedException {
        this.thread.join(millis);
        return !this.thread.isAlive();
    }

    public String toString() {
        return this.thread.toString();
    }
}

