/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.elasticsearch.sink;

import com.couchbase.connector.config.es.BulkRequestConfig;
import com.couchbase.connector.dcp.CheckpointService;
import com.couchbase.connector.dcp.Event;
import com.couchbase.connector.elasticsearch.DocumentLifecycle;
import com.couchbase.connector.elasticsearch.ErrorListener;
import com.couchbase.connector.elasticsearch.io.RequestFactory;
import com.couchbase.connector.elasticsearch.sink.SinkOps;
import com.couchbase.connector.elasticsearch.sink.SinkWorker;
import com.couchbase.connector.elasticsearch.sink.SinkWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkWorkerGroup
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SinkWorkerGroup.class);
    private final ImmutableList<SinkWorker> workers;
    private final BlockingQueue<Throwable> fatalErrorQueue = new LinkedBlockingQueue<Throwable>();

    public SinkWorkerGroup(SinkOps client, CheckpointService checkpointService, RequestFactory requestFactory, ErrorListener errorListener, BulkRequestConfig bulkRequestConfig) {
        Preconditions.checkArgument((bulkRequestConfig.concurrentRequests() > 0 ? 1 : 0) != 0, (Object)"must have at least one worker");
        ImmutableList.Builder workersBuilder = ImmutableList.builder();
        for (int i = 0; i < bulkRequestConfig.concurrentRequests(); ++i) {
            workersBuilder.add((Object)SinkWorker.newWorker(new SinkWriter(client, checkpointService, requestFactory, bulkRequestConfig), this.fatalErrorQueue, errorListener));
        }
        this.workers = workersBuilder.build();
    }

    public void submit(Event e) {
        int workerIndex = e.getVbucket() % this.workers.size();
        DocumentLifecycle.logReceivedFromCouchbase(e, workerIndex);
        ((SinkWorker)this.workers.get(workerIndex)).submit(e);
    }

    public Throwable awaitFatalError() throws InterruptedException {
        return this.fatalErrorQueue.take();
    }

    public long getQueueSize() {
        return this.workers.stream().mapToLong(SinkWorker::getQueueSize).sum();
    }

    public long getCurrentRequestMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.workers.stream().mapToLong(SinkWorker::getCurrentRequestNanos).max().orElseThrow(() -> new AssertionError((Object)"There should be at least one worker.")));
    }

    @Override
    public void close() {
        Duration timeout = Duration.ofSeconds(3L);
        for (SinkWorker w : this.workers) {
            w.close();
        }
        try {
            for (SinkWorker w : this.workers) {
                if (w.join(Math.max(1L, timeout.toMillis()))) continue;
                LOGGER.warn("Worker {} failed to stop after {}", (Object)w, (Object)timeout);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Interrupted while waiting for workers to stop.");
        }
    }
}

