/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.util;

import com.couchbase.client.core.deps.io.netty.bootstrap.ServerBootstrap;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.channel.Channel;
import com.couchbase.client.core.deps.io.netty.channel.ChannelFutureListener;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.channel.ChannelInitializer;
import com.couchbase.client.core.deps.io.netty.channel.EventLoopGroup;
import com.couchbase.client.core.deps.io.netty.channel.SimpleChannelInboundHandler;
import com.couchbase.client.core.deps.io.netty.channel.nio.NioEventLoopGroup;
import com.couchbase.client.core.deps.io.netty.channel.socket.nio.NioServerSocketChannel;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpContentCompressor;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpObject;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpObjectAggregator;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpResponseStatus;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpServerCodec;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.QueryStringDecoder;
import com.couchbase.client.core.deps.io.netty.handler.logging.LogLevel;
import com.couchbase.client.core.deps.io.netty.handler.logging.LoggingHandler;
import com.couchbase.client.core.deps.io.netty.util.concurrent.GenericFutureListener;
import com.couchbase.connector.VersionHelper;
import com.couchbase.connector.cluster.Membership;
import com.couchbase.connector.elasticsearch.Metrics;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServer
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpServer.class);
    private final int httpPort;
    private final EventLoopGroup eventLoopGroup = new NioEventLoopGroup();
    private final ServerBootstrap bootstrap = (ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.eventLoopGroup).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)new HttpServerInitializer()).channel(NioServerSocketChannel.class);
    private boolean started;
    private Channel serverChannel;
    private Membership membership;
    private static final ObjectMapper mapper = new ObjectMapper();

    public HttpServer(int httpPort, Membership membership) {
        this.httpPort = httpPort;
        this.membership = Objects.requireNonNull(membership);
    }

    public synchronized void start() throws IOException {
        if (this.httpPort < 0) {
            LOGGER.debug("HTTP server disabled");
            return;
        }
        if (this.started) {
            throw new IllegalStateException("already started");
        }
        try {
            this.serverChannel = this.bootstrap.bind(this.httpPort).sync().channel();
        }
        catch (Exception e) {
            this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            LOGGER.error("Failed to bind HTTP server to port {}; {}", (Object)this.httpPort, (Object)e.getMessage());
            Throwables.propagateIfPossible((Throwable)e, IOException.class);
            throw new IOException(e);
        }
        this.started = true;
        LOGGER.info("HTTP server listening at http://localhost:{}", (Object)this.getBoundPort());
    }

    public int getConfiguredPort() {
        return this.httpPort;
    }

    public synchronized int getBoundPort() {
        Preconditions.checkState((boolean)this.started, (Object)"not started");
        return ((InetSocketAddress)this.serverChannel.localAddress()).getPort();
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.started) {
            return;
        }
        LOGGER.info("HTTP server shutting down...");
        if (this.serverChannel != null) {
            try {
                this.serverChannel.close().await();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close HTTP server channel", (Throwable)e);
            }
        }
        try {
            this.eventLoopGroup.shutdownGracefully().await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.started = false;
        LOGGER.info("HTTP server shutdown complete.");
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        try (HttpServer server = new HttpServer(31415, Membership.of(1, 2));){
            server.start();
            TimeUnit.DAYS.sleep(1L);
        }
    }

    private static boolean getBoolean(QueryStringDecoder decoder, String paramName, boolean defaultValue) {
        boolean value = decoder.parameters().containsKey(paramName) || defaultValue;
        for (String s : decoder.parameters().getOrDefault(paramName, Collections.emptyList())) {
            value = !s.equals("false");
        }
        return value;
    }

    public class HttpServerHandler
    extends SimpleChannelInboundHandler<HttpObject> {
        protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
            ByteBuf content;
            HttpResponseStatus status;
            String contentType;
            HttpRequest request = (HttpRequest)msg;
            LOGGER.debug("HTTP request: {} ", (Object)request);
            QueryStringDecoder decoder = new QueryStringDecoder(request.uri());
            switch (decoder.path()) {
                case "/": {
                    contentType = "text/html;charset=UTF-8";
                    status = HttpResponseStatus.OK;
                    String html = "<h2>Couchbase Elasticsearch Connector</h2>Version " + VersionHelper.getVersionString() + "<p><a href=\"info\">Connector info</a> (version, membership, etc.)<p><a href=\"metrics/prometheus\">Metrics (Prometheus)</a><p><a href=\"metrics/dropwizard?pretty\">Metrics (Dropwizard)</a>";
                    content = Unpooled.wrappedBuffer((byte[])html.getBytes(StandardCharsets.UTF_8));
                    break;
                }
                case "/info": {
                    Map<String, String> info = Map.of("version", VersionHelper.getVersion(), "commit", VersionHelper.getGitInfo().orElse(""), "membership", HttpServer.this.membership.toString());
                    content = Unpooled.wrappedBuffer((byte[])mapper.writerWithDefaultPrettyPrinter().writeValueAsBytes(info));
                    contentType = "application/json";
                    status = HttpResponseStatus.OK;
                    break;
                }
                case "/metrics": 
                case "/metrics/dropwizard": {
                    boolean pretty = HttpServer.getBoolean(decoder, "pretty", false);
                    ObjectWriter w = pretty ? mapper.writerWithDefaultPrettyPrinter() : mapper.writer();
                    content = Unpooled.wrappedBuffer((byte[])w.writeValueAsBytes((Object)Metrics.toJsonNode()));
                    contentType = "application/json";
                    status = HttpResponseStatus.OK;
                    break;
                }
                case "/metrics/prometheus": {
                    content = Unpooled.wrappedBuffer((byte[])Metrics.toPrometheusExpositionFormat().getBytes(StandardCharsets.UTF_8));
                    contentType = "text/plain; version=0.0.4";
                    status = HttpResponseStatus.OK;
                    break;
                }
                default: {
                    content = Unpooled.wrappedBuffer((byte[])mapper.writeValueAsBytes((Object)("path '" + decoder.path() + "' not found")));
                    contentType = "application/json";
                    status = HttpResponseStatus.NOT_FOUND;
                }
            }
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            ctx.flush();
        }
    }

    public class HttpServerInitializer
    extends ChannelInitializer<Channel> {
        private final int BYTES_PER_MEBIBYTE = 0x100000;
        private final int MAX_REQUEST_CONTENT_LENGTH = 0x100000;

        protected void initChannel(Channel channel) throws Exception {
            channel.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(0x100000, true)}).addLast(new ChannelHandler[]{new HttpContentCompressor()}).addLast(new ChannelHandler[]{new HttpServerHandler()});
        }
    }
}

