/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.util;

import com.couchbase.client.core.env.SecurityConfig;
import com.couchbase.connector.config.ConfigException;
import com.couchbase.connector.config.ConfigHelper;
import com.couchbase.connector.config.common.TrustStoreConfig;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreHelper {
    private static final Logger log = LoggerFactory.getLogger(KeyStoreHelper.class);

    private KeyStoreHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static KeyStore get(String path, Object position, String password) {
        char[] pw = password == null ? null : password.toCharArray();
        try {
            KeyStore keyStore;
            File keyStoreFile = ConfigHelper.resolveIfRelative(path);
            if (!keyStoreFile.exists()) {
                throw new RuntimeException("Trust/Key store file configured at " + String.valueOf(position) + " not found", new FileNotFoundException(keyStoreFile.toString()));
            }
            FileInputStream is = new FileInputStream(keyStoreFile);
            try {
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(is, pw);
                keyStore = ks;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to read trust/key store file " + String.valueOf(keyStoreFile) + " configured at " + String.valueOf(position) + "; " + e.getMessage(), e);
                }
            }
            ((InputStream)is).close();
            return keyStore;
        }
        finally {
            if (pw != null) {
                Arrays.fill(pw, '\u0000');
            }
        }
    }

    public static Supplier<KeyStore> trustStoreFrom(String serviceName, List<X509Certificate> trustedCertificates, @Nullable TrustStoreConfig trustStoreConfig) {
        if (trustedCertificates.isEmpty()) {
            if (trustStoreConfig != null) {
                return trustStoreConfig;
            }
            log.info("Since no Certificate Authority (CA) certificate(s) were specified for {}, the connector will trust the well-known CAs in the JVM's 'cacerts' trust store. If the {} service uses a private CA, make sure to configure the 'pathToCaCertificate' connector config property, or add the CA certificate to `cacerts`.", (Object)serviceName, (Object)serviceName);
            trustedCertificates = SecurityConfig.jvmCaCertificates();
        }
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(trustedCertificates);
        return () -> {
            try {
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(null, null);
                for (int i = 0; i < certs.size(); ++i) {
                    ks.setCertificateEntry(serviceName + "-" + i, (Certificate)certs.get(i));
                }
                return ks;
            }
            catch (IOException | GeneralSecurityException e) {
                throw new ConfigException("Failed to generate KeyStore for " + serviceName + " Certificate Authority (CA) certificate.", e);
            }
        };
    }

    public static String describe(List<X509Certificate> certificates) {
        if (certificates.isEmpty()) {
            return "n/a";
        }
        return certificates.stream().map(it -> "SHA-256 fingerprint: " + KeyStoreHelper.sha512(it) + " " + String.valueOf(it.getSubjectX500Principal()) + " (valid from " + String.valueOf(it.getNotBefore().toInstant()) + " to " + String.valueOf(it.getNotAfter().toInstant()) + ")").collect(Collectors.toList()).toString();
    }

    private static String sha512(X509Certificate cert) {
        try {
            return Hashing.sha256().hashBytes(cert.getEncoded()).toString();
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

