/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ListHelper {
    private ListHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static <T> List<List<T>> chunks(List<T> items, int chunks) {
        Preconditions.checkArgument((chunks > 0 ? 1 : 0) != 0, (Object)"chunks must be > 0");
        Objects.requireNonNull(items);
        int maxChunkSize = (items.size() - 1) / chunks + 1;
        int numFullChunks = chunks - (maxChunkSize * chunks - items.size());
        ArrayList<List<T>> result = new ArrayList<List<T>>(chunks);
        int startIndex = 0;
        for (int i = 0; i < chunks; ++i) {
            int endIndex = startIndex + maxChunkSize;
            if (i >= numFullChunks) {
                --endIndex;
            }
            result.add(items.subList(startIndex, endIndex));
            startIndex = endIndex;
        }
        return result;
    }
}

