/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.util;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class RuntimeHelper {
    private static final Duration shutdownHookTimeout = Duration.ofSeconds(3L);
    private static final List<Thread> managedShutdownHooks = new ArrayList<Thread>();

    private RuntimeHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    private static void halt() {
        System.err.println("Halting.");
        Runtime.getRuntime().halt(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addShutdownHook(Thread hook) {
        Objects.requireNonNull(hook);
        List<Thread> list = managedShutdownHooks;
        synchronized (list) {
            managedShutdownHooks.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeShutdownHook(Thread hook) {
        Objects.requireNonNull(hook);
        List<Thread> list = managedShutdownHooks;
        synchronized (list) {
            return managedShutdownHooks.remove(hook);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                List<Thread> list = managedShutdownHooks;
                synchronized (list) {
                    for (Thread t : managedShutdownHooks) {
                        t.start();
                    }
                    long deadlineNanos = System.nanoTime() + shutdownHookTimeout.toNanos();
                    for (Thread t : managedShutdownHooks) {
                        long remainingMillis = Math.max(1L, TimeUnit.NANOSECONDS.toMillis(deadlineNanos - System.nanoTime()));
                        t.join(remainingMillis);
                        if (!t.isAlive()) continue;
                        System.err.println(String.valueOf(Instant.now()) + " Shutdown hook failed to terminate within " + String.valueOf(shutdownHookTimeout) + " : " + String.valueOf(t));
                        RuntimeHelper.halt();
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                RuntimeHelper.halt();
            }
        }));
    }
}

