/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.util;

import com.google.common.base.Throwables;
import java.util.Optional;

public class ThrowableHelper {
    public static <T extends Throwable> void propagateCauseIfPossible(Throwable t, Class<T> type) throws T {
        ThrowableHelper.propagateIfPresent(ThrowableHelper.findCause(t, type));
    }

    @SafeVarargs
    public static boolean hasCause(Throwable t, Class<? extends Throwable> type, Class<? extends Throwable> ... otherTypes) {
        if (ThrowableHelper.findCause(t, type).isPresent()) {
            return true;
        }
        for (Class<? extends Throwable> other : otherTypes) {
            if (!ThrowableHelper.findCause(t, other).isPresent()) continue;
            return true;
        }
        return false;
    }

    private static <T extends Throwable> void propagateIfPresent(Optional<T> t) throws T {
        if (t.isPresent()) {
            throw (Throwable)t.get();
        }
    }

    private static <T extends Throwable> Optional<T> findCause(Throwable t, Class<T> type) {
        for (Throwable cause : Throwables.getCausalChain((Throwable)t)) {
            if (!type.isAssignableFrom(cause.getClass())) continue;
            return Optional.of((Throwable)type.cast(cause));
        }
        return Optional.empty();
    }

    public static String formatMessageWithStackTrace(String message, Throwable t) {
        return message + System.lineSeparator() + Throwables.getStackTraceAsString((Throwable)t);
    }
}

