/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.consul;

import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.connector.config.common.ConsulConfig;
import com.couchbase.consul.ConsulResponse;
import com.couchbase.consul.ReadTimeoutSetter;
import com.couchbase.consul.internal.ConsulJacksonHelper;
import com.couchbase.consul.internal.OkHttpHelper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.net.HostAndPort;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.ByteString;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public class ConsulHttpClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ConsulHttpClient.class);
    private final JsonMapper mapper;
    private final Dispatcher dispatcher = new Dispatcher();
    private final OkHttpClient client;
    private final HttpUrl baseUrl;
    private final ConsulConfig config;
    private static final MediaType JSON = MediaType.parse((String)"application/json");
    private static final MediaType PLAINTEXT = MediaType.parse((String)"text/plain;charset=UTF-8");

    public ConsulHttpClient(HostAndPort address, ConsulConfig config) {
        this(address, config, ConsulJacksonHelper.consulJsonMapper());
    }

    public ConsulHttpClient(HostAndPort address, ConsulConfig config, JsonMapper mapper) {
        this.dispatcher.setMaxRequests(Integer.MAX_VALUE);
        this.dispatcher.setMaxRequestsPerHost(Integer.MAX_VALUE);
        this.client = new OkHttpClient.Builder().dispatcher(this.dispatcher).callTimeout(ReadTimeoutSetter.CALL_TIMEOUT).addInterceptor((Interceptor)new ReadTimeoutSetter()).build();
        this.baseUrl = HttpUrl.parse((String)("http://" + String.valueOf(address.withDefaultPort(8500)) + "/v1/"));
        this.mapper = Objects.requireNonNull(mapper);
        this.config = Objects.requireNonNull(config);
    }

    public RequestBuilder get(String pathTemplate, String ... pathArgs) {
        return new RequestBuilder(Method.GET, pathTemplate, pathArgs);
    }

    public RequestBuilder put(String pathTemplate, String ... pathArgs) {
        return new RequestBuilder(Method.PUT, pathTemplate, pathArgs);
    }

    public RequestBuilder delete(String pathTemplate, String ... pathArgs) {
        return new RequestBuilder(Method.DELETE, pathTemplate, pathArgs);
    }

    private HttpUrl baseUrl() {
        return this.baseUrl;
    }

    private OkHttpClient client() {
        return this.client;
    }

    private JsonMapper mapper() {
        return this.mapper;
    }

    @Override
    public void close() {
        this.client.dispatcher().executorService().shutdown();
        this.client.dispatcher().cancelAll();
        this.client.connectionPool().evictAll();
    }

    public class RequestBuilder {
        private final String path;
        private final Map<String, Object> queryParams = new LinkedHashMap<String, Object>();
        private final Method method;
        private ByteString content;
        private MediaType contentType;

        public RequestBuilder(Method method, String pathTemplate, String ... pathArgs) {
            this.method = method;
            this.path = StringUtils.removeStart((String)CoreHttpPath.formatPath((String)pathTemplate, (String[])pathArgs), (String)"/");
            if (this.method == Method.PUT) {
                this.content = ByteString.EMPTY;
            }
        }

        public RequestBuilder query(Map<String, ?> params) {
            this.queryParams.putAll(params);
            return this;
        }

        public RequestBuilder query(String ... valuelessParamName) {
            Arrays.stream(valuelessParamName).forEach(it -> this.query((String)it, (Object)""));
            return this;
        }

        public RequestBuilder query(String name, Object value) {
            this.queryParams.put(name, value);
            return this;
        }

        public RequestBuilder blocking(long index, Duration wait) {
            return this.query(Map.of("index", index, "wait", Math.min(1L, wait.toSeconds()) + "s"));
        }

        public RequestBuilder bodyJson(Object body) {
            try {
                return this.setBody(ConsulHttpClient.this.mapper().writeValueAsBytes(body), JSON);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public RequestBuilder bodyText(String text) {
            return this.setBody(text.getBytes(StandardCharsets.UTF_8), PLAINTEXT);
        }

        private RequestBuilder setBody(byte[] content, MediaType contentType) {
            this.content = ByteString.of((byte[])content);
            this.contentType = contentType;
            return this;
        }

        public <T> Mono<ConsulResponse<T>> buildWithResponseType(final Class<T> responseBodyType) {
            return this.buildWithResponseType(new TypeReference<T>(){

                public Type getType() {
                    return responseBodyType;
                }
            });
        }

        public <T> Mono<ConsulResponse<T>> buildWithResponseType(TypeReference<T> responseBodyType) {
            return OkHttpHelper.toMono(ConsulHttpClient.this.client(), this.toOkHttpRequest(), response -> new ConsulResponse<Object>((Response)response, r -> {
                try {
                    byte[] body = Objects.requireNonNull(response.body(), "expected non-null response body").bytes();
                    if (response.code() == 500 || response.code() == 503) {
                        String msg = "Consul request [" + String.valueOf((Object)this.method) + " " + this.path + "] failed with status code " + response.code() + ".";
                        if (body.length > 0) {
                            msg = msg + " Response body: " + new String(body, StandardCharsets.UTF_8);
                        }
                        throw new ConsulInternalServiceError(msg);
                    }
                    return body.length == 0 || responseBodyType == null || !response.isSuccessful() ? null : ConsulHttpClient.this.mapper().readValue(body, responseBodyType);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            })).retryWhen((Retry)Retry.fixedDelay((long)10L, (Duration)Duration.ofSeconds(1L)).jitter(0.25).filter(it -> it instanceof ConsulInternalServiceError).doBeforeRetry(it -> log.info("Retrying failed Consul request. " + it.failure().getMessage())));
        }

        private Request toOkHttpRequest() {
            HttpUrl.Builder urlBuilder = ConsulHttpClient.this.baseUrl().newBuilder().addEncodedPathSegments(this.path);
            this.queryParams.forEach((k, v) -> urlBuilder.addQueryParameter(k, String.valueOf(v)));
            RequestBody body = this.content == null ? null : RequestBody.create((ByteString)this.content, (MediaType)this.contentType);
            Request.Builder builder = new Request.Builder().url(urlBuilder.build()).method(this.method.name(), body);
            ConsulHttpClient.this.config.aclToken().ifPresent(it -> builder.header("X-Consul-Token", it));
            return builder.build();
        }
    }

    static enum Method {
        GET,
        PUT,
        DELETE;

    }

    private static class ConsulInternalServiceError
    extends RuntimeException {
        public ConsulInternalServiceError(String message) {
            super(message);
        }
    }
}

