/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.consul;

import com.couchbase.connector.cluster.consul.ConsulDocumentWatcher;
import com.couchbase.connector.cluster.consul.ConsulResourceWatcher;
import com.couchbase.connector.config.common.ConsulConfig;
import com.couchbase.connector.config.common.ImmutableConsulConfig;
import com.couchbase.consul.ConsulHttpClient;
import com.couchbase.consul.ConsulResponse;
import com.couchbase.consul.KvReadResult;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.net.HostAndPort;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ConsulOps
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ConsulOps.class);
    private final TypeReference<List<String>> LIST_OF_STRINGS = new TypeReference<List<String>>(){};
    private final TypeReference<List<KvReadResult>> LIST_OF_KV_READ_RESULTS = new TypeReference<List<KvReadResult>>(){};
    public static final ConsulConfig DEFAULT_CONFIG = ImmutableConsulConfig.builder().build();
    private static final Duration MAX_WAIT = Duration.ofMinutes(6L);
    private final Duration TIMEOUT = Duration.ofMillis((long)((double)MAX_WAIT.toMillis() * 1.1));
    private final ConsulHttpClient httpClient;
    private final KvOps kvOps;
    private final AgentOps agentOps;
    private final SessionOps sessionOps;
    private final HealthOps healthOps;

    public ConsulOps(HostAndPort address, ConsulConfig config) {
        this.httpClient = new ConsulHttpClient(address, config);
        this.kvOps = new KvOps();
        this.agentOps = new AgentOps();
        this.sessionOps = new SessionOps();
        this.healthOps = new HealthOps();
    }

    public Duration getMaxWait() {
        return MAX_WAIT;
    }

    public ConsulHttpClient httpClient() {
        return this.httpClient;
    }

    public KvOps kv() {
        return this.kvOps;
    }

    public AgentOps agent() {
        return this.agentOps;
    }

    public SessionOps session() {
        return this.sessionOps;
    }

    public HealthOps health() {
        return this.healthOps;
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    public class KvOps {
        public void mutate(String key, Function<Optional<String>, Optional<String>> mutator) {
        }

        public ConsulDocumentWatcher documentWatcher() {
            return new ConsulDocumentWatcher(ConsulOps.this);
        }

        public Flux<Optional<String>> watchOneKey(String key) {
            return this.documentWatcher().watch(key);
        }

        public Flux<List<String>> watchKeys(String prefix) {
            return new ConsulResourceWatcher().watch(opt -> this.listKeys("rpc/", (Map<String, Object>)opt)).map(ConsulResponse::body).distinctUntilChanged().doOnError(t -> log.warn("Watch on key prefix '" + prefix + "' terminated due to error.", t)).doFinally(signal -> log.info("Watch on key prefix '" + prefix + "' terminated: " + String.valueOf(signal)));
        }

        public Mono<Optional<String>> readOneKeyAsString(String key) {
            return this.readOneKey(key).map(ConsulResponse::body).map(it -> it.map(KvReadResult::valueAsString));
        }

        public Mono<ConsulResponse<Optional<KvReadResult>>> readOneKey(String key) {
            return this.readOneKey(key, Map.of());
        }

        public Mono<ConsulResponse<Optional<KvReadResult>>> readOneKey(String key, Map<String, ?> params) {
            return ConsulOps.this.httpClient.get("kv/{}", key).query(params).buildWithResponseType(ConsulOps.this.LIST_OF_KV_READ_RESULTS).doOnSubscribe(it -> log.debug("KV read; key = {} ; params = {}", (Object)key, (Object)params)).doOnNext(it -> log.trace("KV read result: {}", it)).map(it -> it.httpStatusCode() == 404 ? it.withBody(Optional.empty()) : it.requireSuccess().withBody(Optional.of((KvReadResult)((List)it.body()).get(0))));
        }

        public Mono<ConsulResponse<List<KvReadResult>>> readKeys(String key, Map<String, ?> params) {
            return ConsulOps.this.httpClient.get("kv/{}", key).query(params).buildWithResponseType(ConsulOps.this.LIST_OF_KV_READ_RESULTS).map(it -> it.httpStatusCode() == 404 ? it.withBody(List.of()) : it.requireSuccess());
        }

        public Mono<ConsulResponse<List<String>>> listKeys(String prefix, Map<String, Object> params) {
            return ConsulOps.this.httpClient.get("kv/{}", prefix).query(params).query("keys", (Object)"").buildWithResponseType(ConsulOps.this.LIST_OF_STRINGS).map(it -> it.httpStatusCode() == 404 ? it.withBody(List.of()) : it.requireSuccess());
        }

        public Mono<ConsulResponse<Boolean>> upsertKey(String key, String value) {
            return this.upsertKey(key, value, Map.of());
        }

        public Mono<ConsulResponse<Boolean>> upsertKey(String key, String value, Map<String, ?> params) {
            return ConsulOps.this.httpClient.put("kv/{}", key).query(params).bodyText(value).buildWithResponseType(Boolean.class).doOnSubscribe(it -> log.trace("KV upsert; key = {} ; params = {} value = {}", new Object[]{key, params, value})).doOnNext(it -> log.trace("KV upsert result: {}", it)).map(ConsulResponse::requireSuccess);
        }

        public Mono<ConsulResponse<Boolean>> deleteKey(String key) {
            return ConsulOps.this.httpClient.delete("kv/{}", key).buildWithResponseType(Boolean.class).map(ConsulResponse::requireSuccess);
        }
    }

    public static class CancelMutationException
    extends RuntimeException {
    }

    public class AgentOps {
        public Mono<ConsulResponse<Void>> register(Map<String, ?> registration, Map<String, ?> params) {
            return ConsulOps.this.httpClient.put("agent/service/register", new String[0]).query(params).bodyJson(registration).buildWithResponseType(Void.class).map(ConsulResponse::requireSuccess);
        }

        public Mono<ConsulResponse<Void>> deregister(String serviceId) {
            return ConsulOps.this.httpClient.put("agent/service/deregister/{}", serviceId).buildWithResponseType(Void.class);
        }

        public Mono<ConsulResponse<Void>> check(String state, String checkId, Map<String, ?> params) {
            return ConsulOps.this.httpClient.put("agent/check/{}/{}", state, checkId).query(params).buildWithResponseType(Void.class).map(ConsulResponse::requireSuccess);
        }

        public Mono<ConsulResponse<ObjectNode>> self() {
            return ConsulOps.this.httpClient.get("agent/self", new String[0]).buildWithResponseType(ObjectNode.class).map(ConsulResponse::requireSuccess);
        }
    }

    public class HealthOps {
        public Mono<ConsulResponse<ArrayNode>> health(String service, Map<String, ?> params) {
            return ConsulOps.this.httpClient.get("health/service/{}", service).query(params).buildWithResponseType(ArrayNode.class).map(ConsulResponse::requireSuccess);
        }
    }

    public class SessionOps {
        public Mono<ConsulResponse<String>> createSession(Map<String, ?> session, Map<String, ?> params) {
            return ConsulOps.this.httpClient.put("session/create", new String[0]).query(params).bodyJson(session).buildWithResponseType(ObjectNode.class).map(ConsulResponse::requireSuccess).map(response -> response.map(json -> Objects.requireNonNull(json.path("ID").textValue(), "session/create response missing ID property")));
        }
    }
}

