/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.consul;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import okhttp3.Headers;
import okhttp3.Response;

public class ConsulResponse<T> {
    private final int httpStatusCode;
    private final String httpStatusMessage;
    private final String defaultAclPolicy;
    private final OptionalLong index;
    private final boolean knownLeader;
    private final Optional<Duration> lastContact;
    private final String queryBackend;
    private final Map<String, List<String>> headers;
    private final T body;

    private ConsulResponse(int httpStatusCode, String httpStatusMessage, String defaultAclPolicy, OptionalLong index, boolean knownLeader, Optional<Duration> lastContact, String queryBackend, Map<String, List<String>> headers, T body) {
        this.httpStatusCode = httpStatusCode;
        this.httpStatusMessage = httpStatusMessage;
        this.defaultAclPolicy = defaultAclPolicy;
        this.index = index;
        this.knownLeader = knownLeader;
        this.lastContact = lastContact;
        this.queryBackend = queryBackend;
        this.headers = headers;
        this.body = body;
    }

    public ConsulResponse(Response response, Function<Response, T> bodyExtractor) {
        Headers headers = response.headers();
        this.defaultAclPolicy = headers.get("X-Consul-Default-Acl-Policy");
        this.lastContact = Optional.ofNullable(headers.get("X-Consul-Lastcontact")).map(Long::parseLong).map(Duration::ofMillis);
        this.headers = headers.toMultimap();
        this.knownLeader = Optional.ofNullable(headers.get("X-Consul-Knownleader")).map(Boolean::parseBoolean).orElse(false);
        this.queryBackend = headers.get("X-Consul-Query-Backend");
        this.index = Optional.ofNullable(headers.get("X-Consul-Index")).map(Long::parseUnsignedLong).map(OptionalLong::of).orElse(OptionalLong.empty());
        this.httpStatusCode = response.code();
        this.httpStatusMessage = response.message();
        this.body = bodyExtractor.apply(response);
    }

    public <R> ConsulResponse<R> withBody(R newBody) {
        return new ConsulResponse<R>(this.httpStatusCode, this.httpStatusMessage, this.defaultAclPolicy, this.index, this.knownLeader, this.lastContact, this.queryBackend, this.headers, newBody);
    }

    public <R> ConsulResponse<R> map(Function<T, R> bodyTransform) {
        return this.withBody(bodyTransform.apply(this.body));
    }

    public String defaultAclPolicy() {
        return this.defaultAclPolicy;
    }

    public OptionalLong index() {
        return this.index;
    }

    public boolean knownLeader() {
        return this.knownLeader;
    }

    public Optional<Duration> lastContact() {
        return this.lastContact;
    }

    public String queryBackend() {
        return this.queryBackend;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public boolean isSuccessful() {
        return this.httpStatusCode >= 200 && this.httpStatusCode <= 299;
    }

    public ConsulResponse<T> requireSuccess() {
        if (!this.isSuccessful()) {
            throw new RuntimeException("Consul response had unexpected HTTP status code: " + this.httpStatusCode + " ; " + String.valueOf(this));
        }
        return this;
    }

    public T body() {
        return this.body;
    }

    public int httpStatusCode() {
        return this.httpStatusCode;
    }

    public String httpStatusMessage() {
        return this.httpStatusMessage;
    }

    public String toString() {
        return "ConsulResponse{httpStatusCode=" + this.httpStatusCode + ", httpStatusMessage='" + this.httpStatusMessage + "', defaultAclPolicy='" + this.defaultAclPolicy + "', index=" + String.valueOf(this.index) + ", knownLeader=" + this.knownLeader + ", lastContact=" + String.valueOf(this.lastContact) + ", queryBackend='" + this.queryBackend + "', headers=" + String.valueOf(this.headers) + ", body=" + String.valueOf(this.body) + "}";
    }
}

