/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.consul;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class KvReadResult {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final String key;
    private final long flags;
    private final byte[] value;
    private final String session;
    private final long createIndex;
    private final long modifyIndex;
    private final long lockIndex;

    @JsonCreator
    public KvReadResult(@JsonProperty(value="Key") String key, @JsonProperty(value="Flags") long flags, @JsonProperty(value="Value") byte[] value, @JsonProperty(value="Session") String session, @JsonProperty(value="CreateIndex") long createIndex, @JsonProperty(value="ModifyIndex") long modifyIndex, @JsonProperty(value="LockIndex") long lockIndex) {
        this.key = key;
        this.flags = flags;
        this.value = value == null ? EMPTY_BYTE_ARRAY : value;
        this.session = session;
        this.createIndex = createIndex;
        this.modifyIndex = modifyIndex;
        this.lockIndex = lockIndex;
    }

    public String key() {
        return this.key;
    }

    public long flags() {
        return this.flags;
    }

    public byte[] value() {
        return this.value;
    }

    public String valueAsString() {
        return new String(this.value, StandardCharsets.UTF_8);
    }

    public Optional<String> session() {
        return Optional.ofNullable(this.session);
    }

    public long createIndex() {
        return this.createIndex;
    }

    public long modifyIndex() {
        return this.modifyIndex;
    }

    public long lockIndex() {
        return this.lockIndex;
    }

    public String toString() {
        return "KvReadResult{key='" + this.key + "', flags=" + this.flags + ", session='" + this.session + "', createIndex=" + this.createIndex + ", modifyIndex=" + this.modifyIndex + ", lockIndex=" + this.lockIndex + ", value=" + this.valueAsString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KvReadResult that = (KvReadResult)o;
        return this.flags == that.flags && this.createIndex == that.createIndex && this.modifyIndex == that.modifyIndex && this.lockIndex == that.lockIndex && this.key.equals(that.key) && Arrays.equals(this.value, that.value) && Objects.equals(this.session, that.session);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.modifyIndex, this.lockIndex);
    }
}

