/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.consul;

import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.core.util.Golang;
import com.couchbase.consul.internal.OkHttpHelper;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jspecify.annotations.NonNull;

public class ReadTimeoutSetter
implements Interceptor {
    private static final Duration MAX_WAIT = Duration.ofMinutes(10L);
    public static final Duration CALL_TIMEOUT = ReadTimeoutSetter.addConsulJitter(MAX_WAIT).plus(Duration.ofSeconds(10L));

    public @NonNull Response intercept(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        boolean hasIndex = request.url().queryParameterNames().contains("index");
        if (!hasIndex) {
            return chain.proceed(request);
        }
        Duration wait = ReadTimeoutSetter.getWait(request).orElse(null);
        if (wait == null) {
            request = OkHttpHelper.withQueryParam(request, "wait", "5m");
            wait = ReadTimeoutSetter.getWait(request).orElseThrow();
        }
        if (wait.compareTo(MAX_WAIT) > 0) {
            throw new IllegalArgumentException("Specified wait " + String.valueOf(wait) + " is greater than max wait " + String.valueOf(MAX_WAIT));
        }
        wait = ReadTimeoutSetter.addConsulJitter(wait);
        return chain.withReadTimeout((int)wait.toMillis(), TimeUnit.MILLISECONDS).proceed(request);
    }

    @VisibleForTesting
    static Duration addConsulJitter(Duration wait) {
        int gracePeriodSeconds = 10;
        int waitSecondsPlusJitter = Math.toIntExact((long)Math.ceil((double)wait.toSeconds() * 1.0625));
        return Duration.ofSeconds(gracePeriodSeconds + waitSecondsPlusJitter);
    }

    @VisibleForTesting
    static Optional<Duration> getWait(Request r) {
        String wait = r.url().queryParameter("wait");
        return Optional.ofNullable(CbStrings.emptyToNull((String)wait)).map(ReadTimeoutSetter::parseWait);
    }

    private static Duration parseWait(String s) {
        return Golang.parseDuration((String)s);
    }
}

