/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.consul.internal;

import java.io.IOException;
import java.util.function.Function;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jspecify.annotations.NonNull;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class OkHttpHelper {
    private OkHttpHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static <T> Mono<T> toMono(OkHttpClient client, Request request, Function<Response, T> responseTransformer) {
        return Mono.create(sink -> {
            Call call = client.newCall(request);
            sink.onCancel(() -> ((Call)call).cancel());
            call.enqueue(new Callback((MonoSink)sink, responseTransformer){
                final /* synthetic */ MonoSink val$sink;
                final /* synthetic */ Function val$responseTransformer;
                {
                    this.val$sink = monoSink;
                    this.val$responseTransformer = function;
                }

                public void onFailure(@NonNull Call call, @NonNull IOException e) {
                    this.val$sink.error((Throwable)e);
                }

                public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                    try (Response response2 = response;){
                        this.val$sink.success(this.val$responseTransformer.apply(response));
                    }
                    catch (Throwable t) {
                        this.val$sink.error(t);
                    }
                }
            });
        });
    }

    public static Request withQueryParam(Request original, String paramName, String paramValue) {
        return original.newBuilder().url(original.url().newBuilder().setQueryParameter(paramName, paramValue).build()).build();
    }
}

