/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc.internal.parser;

import com.github.therapi.runtimejavadoc.Link;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinkParser {
    private static final Pattern linkPattern = Pattern.compile("^(?<classname>[\\w.]+)?(?:#(?<member>\\w+))?(?:\\((?<params>.*)\\))?(?:\\s(?<label>.+))?$");

    public static Link createLinkElement(String owningClass, String value) {
        Matcher linkMatcher = linkPattern.matcher(value);
        if (!linkMatcher.matches()) {
            return null;
        }
        String classRef = linkMatcher.group("classname");
        String memberRef = linkMatcher.group("member");
        String params = linkMatcher.group("params");
        String label = linkMatcher.group("label");
        String effectiveClassName = classRef == null ? owningClass : classRef;
        String effectiveLabel = label != null ? label : linkMatcher.group(0);
        return new Link(effectiveLabel, effectiveClassName, memberRef, LinkParser.formatMember(params));
    }

    private static List<String> formatMember(String params) {
        if (params != null && !params.trim().isEmpty()) {
            return Arrays.asList(params.trim().split(",\\s*"));
        }
        return Collections.emptyList();
    }
}

